/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.Locale;
import java.util.function.Function;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.NestedColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.NullType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SqlExpressionResolver {
    public static ColumnReferenceKey createColumnReferenceKey(String tableExpression, String columnExpression, JdbcMapping jdbcMapping) {
        return SqlExpressionResolver.createColumnReferenceKey(tableExpression, new SelectablePath(columnExpression), jdbcMapping);
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, String columnExpression, JdbcMapping jdbcMapping) {
        return SqlExpressionResolver.createColumnReferenceKey(tableReference, new SelectablePath(columnExpression), jdbcMapping);
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, SelectablePath selectablePath, JdbcMapping jdbcMapping) {
        if (!1.$assertionsDisabled && tableReference == null) {
            throw new AssertionError((Object)"tableReference expected to be non-null");
        }
        if (!1.$assertionsDisabled && selectablePath == null) {
            throw new AssertionError((Object)"selectablePath expected to be non-null");
        }
        if (!1.$assertionsDisabled && tableReference.getIdentificationVariable() == null) {
            throw new AssertionError((Object)"tableReference#identificationVariable expected to be non-null");
        }
        String qualifier = tableReference.getIdentificationVariable();
        return SqlExpressionResolver.createColumnReferenceKey(qualifier, selectablePath, jdbcMapping);
    }

    public static ColumnReferenceKey createColumnReferenceKey(String qualifier, SelectablePath selectablePath, JdbcMapping jdbcMapping) {
        if (!1.$assertionsDisabled && qualifier == null) {
            throw new AssertionError((Object)"qualifier expected to be non-null");
        }
        if (!1.$assertionsDisabled && selectablePath == null) {
            throw new AssertionError((Object)"selectablePath expected to be non-null");
        }
        if (!1.$assertionsDisabled && jdbcMapping == null) {
            throw new AssertionError((Object)"jdbcMapping expected to be non-null");
        }
        return new ColumnReferenceKey(qualifier, selectablePath, jdbcMapping);
    }

    public static ColumnReferenceKey createColumnReferenceKey(String columnExpression) {
        if (!1.$assertionsDisabled && columnExpression == null) {
            throw new AssertionError((Object)"columnExpression expected to be non-null");
        }
        return SqlExpressionResolver.createColumnReferenceKey("", new SelectablePath(columnExpression), (JdbcMapping)NullType.INSTANCE);
    }

    public static ColumnReferenceKey createColumnReferenceKey(String tableExpression, SelectableMapping selectable) {
        return SqlExpressionResolver.createColumnReferenceKey(tableExpression, selectable.getSelectablePath(), selectable.getJdbcMapping());
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, SelectableMapping selectable) {
        if (!1.$assertionsDisabled && !tableReference.containsAffectedTableName(selectable.getContainingTableExpression())) {
            throw new AssertionError((Object)String.format(Locale.ROOT, "Expecting tables to match between TableReference (%s) and SelectableMapping (%s)", tableReference.getTableId(), selectable.getContainingTableExpression()));
        }
        return SqlExpressionResolver.createColumnReferenceKey(tableReference, selectable.getSelectablePath(), selectable.getJdbcMapping());
    }

    default public Expression resolveSqlExpression(TableReference tableReference, SelectableMapping selectableMapping) {
        return this.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping), (SqlAstProcessingState processingState) -> tableReference.isEmbeddableFunctionTableReference() ? new NestedColumnReference(tableReference.asEmbeddableFunctionTableReference(), selectableMapping) : new ColumnReference(tableReference, selectableMapping));
    }

    public Expression resolveSqlExpression(ColumnReferenceKey var1, Function<SqlAstProcessingState, Expression> var2);

    public SqlSelection resolveSqlSelection(Expression var1, JavaType<?> var2, FetchParent var3, TypeConfiguration var4);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class ColumnReferenceKey {
        private final String tableQualifier;
        private final SelectablePath selectablePath;
        private final JdbcMapping jdbcMapping;

        public ColumnReferenceKey(String tableQualifier, SelectablePath selectablePath, JdbcMapping jdbcMapping) {
            this.tableQualifier = tableQualifier;
            this.selectablePath = selectablePath;
            this.jdbcMapping = jdbcMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnReferenceKey that = (ColumnReferenceKey)o;
            return this.tableQualifier.equals(that.tableQualifier) && this.selectablePath.equals(that.selectablePath) && this.jdbcMapping.equals(that.jdbcMapping);
        }

        public int hashCode() {
            int result = this.tableQualifier.hashCode();
            result = 31 * result + this.selectablePath.hashCode();
            result = 31 * result + this.jdbcMapping.hashCode();
            return result;
        }
    }
}

