/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ArrayInitializer
extends AbstractImmediateCollectionInitializer<AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData> {
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int indexBase;

    public ArrayInitializer(NavigablePath navigablePath, PluralAttributeMapping arrayDescriptor, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState, Fetch listIndexFetch, Fetch elementFetch) {
        super(navigablePath, arrayDescriptor, parent, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.listIndexAssembler = listIndexFetch.createAssembler(this, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.indexBase = this.getCollectionAttributeMapping().getIndexMetadata().getListIndexBase();
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        super.forEachSubInitializer(consumer, data);
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public @Nullable PersistentArrayHolder<?> getCollectionInstance(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        return (PersistentArrayHolder)super.getCollectionInstance(data);
    }

    @Override
    protected void readCollectionRow(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data, List<Object> loadingState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new HibernateException("Illegal null value for array index encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        int index = indexValue;
        if (this.indexBase != 0) {
            index -= this.indexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, element);
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Object[] array = (Object[])this.getInitializedPart().getValue(parentInstance);
        assert (array != null);
        data.setCollectionInstance(data.getRowProcessingState().getSession().getPersistenceContextInternal().getCollectionHolder(array));
        data.setState(Initializer.State.INITIALIZED);
        this.initializeSubInstancesFromParent(data);
    }

    @Override
    protected void initializeSubInstancesFromParent(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            Iterator iter = this.getCollectionInstance(data).elements();
            while (iter.hasNext()) {
                initializer.initializeInstanceFromParent(iter.next(), rowProcessingState);
            }
        }
    }

    @Override
    protected void resolveInstanceSubInitializers(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        RowProcessingState rowProcessingState;
        Integer index;
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null && (index = this.listIndexAssembler.assemble(rowProcessingState = data.getRowProcessingState())) != null) {
            PersistentArrayHolder<?> arrayHolder = this.getCollectionInstance(data);
            assert (arrayHolder != null);
            if (this.indexBase != 0) {
                index = index - this.indexBase;
            }
            initializer.resolveInstance(Array.get(arrayHolder.getArray(), index), rowProcessingState);
        }
    }

    @Override
    public DomainResultAssembler<?> getIndexAssembler() {
        return this.listIndexAssembler;
    }

    @Override
    public DomainResultAssembler<?> getElementAssembler() {
        return this.elementAssembler;
    }

    public String toString() {
        return "ArrayInitializer{" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

