/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.slm.GetLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetLifecycleRequest
extends RequestBase {
    @Nullable
    private final Time masterTimeout;
    private final List<String> policyId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<GetLifecycleRequest, GetLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetLifecycleRequest, GetLifecycleResponse>("es/slm.get_lifecycle", request -> "GET", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.policyId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _policyId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.policyId())) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("policyId", request.policyId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetLifecycleResponse._DESERIALIZER);

    private GetLifecycleRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.policyId = ApiTypeHelper.unmodifiable(builder.policyId);
        this.timeout = builder.timeout;
    }

    public static GetLifecycleRequest of(Function<Builder, ObjectBuilder<GetLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> policyId() {
        return this.policyId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetLifecycleRequest> {
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> policyId;
        @Nullable
        private Time timeout;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder policyId(List<String> list) {
            this.policyId = Builder._listAddAll(this.policyId, list);
            return this;
        }

        public final Builder policyId(String value, String ... values) {
            this.policyId = Builder._listAdd(this.policyId, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetLifecycleRequest build() {
            this._checkSingleUse();
            return new GetLifecycleRequest(this);
        }
    }
}

