/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.pwa.model.PwaShortcut;
import io.meeds.pwa.model.PwaShortcutIcon;
import io.meeds.pwa.plugin.PwaShortcutPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AppCenterPwaShortcutPlugin
implements PwaShortcutPlugin {
    public static final String PWA_SMALL_ICON_BASE_PATH = "/pwa/rest/manifest/smallIcon?v=";
    private static final String PWA_SHORTCUT_IMG_DIMENSIONS = "192x192";
    @Autowired
    private PortalContainer container;
    @Autowired
    private UserPortalConfigService portalConfigService;

    public List<PwaShortcut> getShortcuts(String username) {
        List<Application> applications = ((ApplicationCenterService)this.container.getComponentInstanceOfType(ApplicationCenterService.class)).getMandatoryAndFavoriteApplications(Pageable.unpaged(), username, this.getUserLocale(username)).getApplications().stream().filter(Application::isPwa).toList();
        if (applications.isEmpty()) {
            return Collections.emptyList();
        }
        String defaultPortal = this.getDefaultPortal(username);
        return applications.stream().map(app -> this.toShortcut((Application)app, String.format("/portal/%s", defaultPortal), username)).toList();
    }

    private PwaShortcut toShortcut(Application application, String defaultPortalPath, String username) {
        return new PwaShortcut(application.getTitle(), application.getTitle(), application.getDescription(), this.getUrl(application, defaultPortalPath, username), this.getShortcutIcons(application));
    }

    private List<PwaShortcutIcon> getShortcutIcons(Application application) {
        return StringUtils.isBlank((CharSequence)application.getImageUrl()) ? Collections.singletonList(new PwaShortcutIcon(String.format("%s%s&sizes=%s", PWA_SMALL_ICON_BASE_PATH, application.hashCode(), PWA_SHORTCUT_IMG_DIMENSIONS), PWA_SHORTCUT_IMG_DIMENSIONS, null, null)) : Collections.singletonList(new PwaShortcutIcon(String.format("%s&sizes=%s", this.getFullImageUrl(application), PWA_SHORTCUT_IMG_DIMENSIONS), PWA_SHORTCUT_IMG_DIMENSIONS, null, null));
    }

    private String getUrl(Application application, String defaultPortalPath, String username) {
        ApplicationType type = application.getType() == null ? ApplicationType.LINK : application.getType();
        return switch (type) {
            case ApplicationType.LINK -> application.getUrl().replace("./", defaultPortalPath + "/").replace("@user@", username == null ? "" : username);
            case ApplicationType.DRAWER -> String.format("%s?appCenterDrawer=%s", defaultPortalPath, application.getUrl());
            case ApplicationType.PORTLET -> String.format("%s?appCenterPortlet=%s", defaultPortalPath, application.getUrl());
            default -> application.getUrl();
        };
    }

    private String getDefaultPortal(String username) {
        PortalConfig defaultSite = this.portalConfigService.getDefaultSite(username);
        return defaultSite == null ? this.portalConfigService.getMetaPortal() : defaultSite.getName();
    }

    private String getFullImageUrl(Application application) {
        return CommonsUtils.getCurrentDomain() + application.getImageUrl();
    }

    private Locale getUserLocale(String username) {
        try {
            return LocaleContextInfoUtils.getUserLocale((String)username);
        }
        catch (Exception e) {
            return ResourceBundleService.DEFAULT_CROWDIN_LOCALE;
        }
    }
}

