/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.onboarding;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONObject;

public class OnboardingHandler
extends JspBasedWebHandler {
    private static final QualifiedName SERVER_CAPTCHA = QualifiedName.create((String)"gtn", (String)"serveCaptcha");
    protected static Log log = ExoLogger.getLogger(OnboardingHandler.class);
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String PASSWORD_CONFIRM_PARAM = "password2";
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    public static final String NAME = "on-boarding";
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final String CAPTCHA_PARAM = "captcha";
    public static final String ACTION_PARAM = "action";
    public static final String RESET_PASSWORD_ACTION_NAME = "resetPassword";
    public static final String EXPIRED_ACTION_NAME = "expired";
    public static final String ERROR_MESSAGE_PARAM = "error";
    public static final String TOKEN_ID_PARAM = "tokenId";
    public static final int CAPTCHA_WIDTH = 200;
    public static final int CAPTCHA_HEIGHT = 50;
    public static final String ONBOARDING_JSP_PATH = "/WEB-INF/jsp/onboarding/reset_password.jsp";
    private ServletContext servletContext;
    private PasswordRecoveryService passwordRecoveryService;
    private ResourceBundleService resourceBundleService;
    private OrganizationService organizationService;

    public OnboardingHandler(PortalContainer container, PasswordRecoveryService passwordRecoveryService, ResourceBundleService resourceBundleService, OrganizationService organizationService, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.servletContext = container.getPortalContext();
        this.passwordRecoveryService = passwordRecoveryService;
        this.resourceBundleService = resourceBundleService;
        this.organizationService = organizationService;
    }

    public String getHandlerName() {
        return NAME;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username;
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleService.getSharedResourceBundleNames(), locale);
        String serveCaptcha = controllerContext.getParameter(SERVER_CAPTCHA);
        if ("true".equals(serveCaptcha)) {
            return this.serveCaptchaImage(request, response);
        }
        String token = controllerContext.getParameter(TOKEN);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String string = username = StringUtils.isBlank((CharSequence)token) ? null : this.passwordRecoveryService.verifyToken(token, "onboard");
        if (username == null) {
            request.setAttribute(ACTION_PARAM, (Object)EXPIRED_ACTION_NAME);
            return false;
        }
        String requestAction = request.getParameter(ACTION_PARAM);
        if (RESET_PASSWORD_ACTION_NAME.equalsIgnoreCase(requestAction)) {
            String password = request.getParameter(PASSWORD_PARAM);
            String confirmPass = request.getParameter(PASSWORD_CONFIRM_PARAM);
            String requestedUsername = request.getParameter(USERNAME_PARAM);
            String captcha = request.getParameter(CAPTCHA_PARAM);
            if (!this.isValidCaptch(request.getSession(), captcha)) {
                OnboardingHandler.returnSubmissionError(resourceBundle.getString("gatein.forgotPassword.captchaError"), response);
                return true;
            }
            if (this.validateUserAndPassword(username, requestedUsername, password, confirmPass, parameters, resourceBundle, locale)) {
                if (this.passwordRecoveryService.changePass(token, "onboard", username, password)) {
                    String loginPath = this.servletContext.getContextPath() + "/login";
                    User user = this.findUser(username);
                    if (user != null) {
                        loginPath = loginPath + "?email=" + user.getEmail();
                    }
                    response.sendRedirect(loginPath);
                    return true;
                }
                OnboardingHandler.returnSubmissionError(resourceBundle.getString("gatein.forgotPassword.resetPasswordFailure"), response);
                return true;
            }
            OnboardingHandler.returnSubmissionError((String)parameters.get(ERROR_MESSAGE_PARAM), response);
            return true;
        }
        request.setAttribute(USERNAME_PARAM, (Object)this.escapeXssCharacters(username));
        request.setAttribute(TOKEN_ID_PARAM, (Object)token);
        request.setAttribute(ACTION_PARAM, (Object)RESET_PASSWORD_ACTION_NAME);
        return false;
    }

    protected boolean isValidCaptch(HttpSession session, String captchaValue) {
        Captcha captcha = (Captcha)session.getAttribute(NAME);
        return captcha != null && StringUtils.isNotBlank((CharSequence)captchaValue) && captcha.isCorrect(captchaValue);
    }

    private boolean validateUserAndPassword(String tokenUsername, String requestedUsername, String password, String confirmPass, Map<String, Object> parameters, ResourceBundle bundle, Locale locale) {
        if (requestedUsername == null || !requestedUsername.equals(tokenUsername)) {
            String errorMessage = bundle.getString("gatein.forgotPassword.usernameChanged");
            errorMessage = errorMessage.replace("{0}", tokenUsername);
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
            return false;
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)confirmPass)) {
            parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.confirmPasswordNotMatch"));
            return false;
        }
        String errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
            return false;
        }
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
        additionalParameters.forEach((arg_0, arg_1) -> ((JSONObject)applicationParameters).put(arg_0, arg_1));
    }

    private User findUser(String usernameOrEmail) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(usernameOrEmail, UserStatus.ANY);
        if (user == null && usernameOrEmail.contains("@")) {
            Query query = new Query();
            query.setEmail(usernameOrEmail);
            ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (list != null && list.getSize() > 0) {
                user = ((User[])list.load(0, 1))[0];
            }
        }
        return user;
    }

    public String escapeXssCharacters(String message) {
        message = message == null ? null : message.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
        return message;
    }

    private boolean serveCaptchaImage(HttpServletRequest req, HttpServletResponse resp) {
        Captcha captcha;
        HttpSession session = req.getSession();
        if (session.getAttribute(NAME) == null) {
            List<Font> textFonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
            captcha = new Captcha.Builder(200, 50).addText(new DefaultTextProducer(5), new DefaultWordRenderer(Color.WHITE, textFonts)).gimp().addNoise().addBackground().build();
            session.setAttribute(NAME, (Object)captcha);
            this.writeImage(resp, captcha.getImage());
        }
        captcha = (Captcha)session.getAttribute(NAME);
        this.writeImage(resp, captcha.getImage());
        return true;
    }

    private void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), bi);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void returnSubmissionError(String message, HttpServletResponse response) throws IOException {
        response.setStatus(400);
        response.setContentType("application/json");
        response.getOutputStream().write(new JSONObject().put(ERROR_MESSAGE_PARAM, (Object)message).toString().getBytes());
    }
}

