/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.operation;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.ExternalContext;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.ManagedUser;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.RuntimeContext;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.model.Model;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.api.operation.OperationAttachment;
import org.gatein.management.api.operation.OperationAttributes;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.core.api.operation.OperationAttributesImpl;

public class OperationContextImpl
implements OperationContext {
    private final ManagedRequest request;
    private final ManagedResource resource;
    private final RuntimeContext runtimeContext;
    private final ExternalContext externalContext;
    private final BindingProvider bindingProvider;
    private final Deque<OperationAttachment> attachments;
    private final OperationAttributes attributes;
    private final Locale locale;
    private final ModelProvider modelProvider;

    public OperationContextImpl(final ManagedRequest request, ManagedResource resource, RuntimeContext runtimeContext, ExternalContext externalContext, BindingProvider bindingProvider, ModelProvider modelProvider) {
        ArrayDeque<OperationAttachment> list = new ArrayDeque<OperationAttachment>();
        list.push(new OperationAttachment(){

            public InputStream getStream() {
                return request.getDataStream();
            }
        });
        this.request = request;
        this.resource = resource;
        this.runtimeContext = runtimeContext;
        this.externalContext = externalContext;
        this.bindingProvider = bindingProvider;
        this.modelProvider = modelProvider;
        this.attachments = list;
        this.attributes = new OperationAttributesImpl(request.getAttributes());
        this.locale = request.getLocale();
    }

    public ManagedUser getUser() {
        final String user = this.externalContext.getRemoteUser();
        if (user != null) {
            return new ManagedUser(){

                public String getUserName() {
                    return user;
                }
            };
        }
        return null;
    }

    public ManagedResource getManagedResource() {
        return this.resource;
    }

    public PathAddress getAddress() {
        return this.request.getAddress();
    }

    public String getOperationName() {
        return this.request.getOperationName();
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public Model newModel() {
        return this.modelProvider.newModel();
    }

    public <T extends ModelValue> T newModel(Class<T> modelType) {
        return (T)this.modelProvider.newModel(modelType);
    }

    public OperationAttributes getAttributes() {
        return this.attributes;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public OperationAttachment getAttachment(boolean remove) {
        if (remove) {
            return this.attachments.pop();
        }
        return this.attachments.peek();
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public ContentType getContentType() {
        return this.request.getContentType();
    }
}

