/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.category.injection.CategoryImportService$AjcClosure1;
import io.meeds.social.category.injection.CategoryTranslationImportService;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryDescriptor;
import io.meeds.social.category.model.CategoryDescriptorList;
import io.meeds.social.category.storage.CategoryStorage;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order
public class CategoryImportService {
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    private static final String CATEGORY_IMPORT = "CATEGORY_IMPORT";
    private static final Scope CATEGORY_IMPORT_SCOPE;
    private static final Context CATEGORY_CONTEXT;
    private static final String CATEGORY_VERSION = "version";
    private static final Log LOG;
    private long superUserIdentityId;
    private long adminGroupOwnerId;
    @Autowired
    private CategoryTranslationImportService categoryTranslationImportService;
    @Autowired
    private CategoryStorage categoryStorage;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.categories.import.override:false}")
    private boolean forceReimport;
    @Value(value="${meeds.categories.import.version:1}")
    private long categoryImportVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importDefaultCategories);
    }

    @ContainerTransactional
    public void importDefaultCategories() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        CategoryImportService$AjcClosure1 categoryImportService$AjcClosure1 = new CategoryImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(categoryImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<CategoryDescriptor> parseDescriptors(URL url) {
        List list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                CategoryDescriptorList list2 = (CategoryDescriptorList)JsonUtils.fromJsonString((String)content, CategoryDescriptorList.class);
                List list3 = list = list2 != null ? list2.getDescriptors() : Collections.emptyList();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unknown error happened while parsing categories from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(CategoryDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getSettingValue(descriptorId);
        if (this.forceReimport || existingId == 0L) {
            Category rootCategory = this.categoryStorage.getRootCategory(this.getAdminGroupIdentityId());
            if (rootCategory == null) {
                rootCategory = new Category(0L, 0L, null, this.getSuperUserIdentityId(), this.getAdminGroupIdentityId(), List.of(ADMINISTRATORS_GROUP));
                rootCategory = this.categoryStorage.createCategory(rootCategory);
            }
            this.importCategory(descriptor, existingId, rootCategory.getId());
        } else {
            LOG.debug("Ignore re-importing category {}", new Object[]{descriptorId});
        }
    }

    protected void importCategory(CategoryDescriptor d, long oldId, long parentId) {
        String descriptorId = d.getNameId();
        LOG.info("Importing category {}", new Object[]{descriptorId});
        try {
            Category category = this.createCategory(d, oldId, parentId);
            if (this.forceReimport || oldId == 0L || category.getId() != oldId) {
                LOG.info("Importing category {} title translations", new Object[]{descriptorId});
                this.saveNames(d, category);
                this.setSettingValue(d.getNameId(), category.getId());
            }
            LOG.info("Importing category {} finished successfully", new Object[]{descriptorId});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing category {}", new Object[]{descriptorId, e});
        }
    }

    protected void saveNames(CategoryDescriptor d, Category category) {
        this.categoryTranslationImportService.saveTranslationLabels("category", category.getId(), "name", d.getNames());
    }

    protected Category createCategory(CategoryDescriptor d, long oldId, long parentId) {
        boolean isNew;
        Category category = null;
        if (oldId > 0L) {
            category = this.categoryStorage.getCategory(oldId);
        }
        boolean bl = isNew = category == null;
        if (isNew) {
            category = new Category();
        }
        category.setParentId(Math.max(parentId, 0L));
        category.setIcon(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{d.getIcon()}) ? d.getIcon() : "fa-th-large");
        category.setCreatorId(this.getSuperUserIdentityId());
        category.setOwnerId(this.getSuperUserIdentityId());
        category.setLinkPermissions(d.getLinkPermissions());
        category = isNew ? this.categoryStorage.createCategory(category) : this.categoryStorage.updateCategory(category);
        if (CollectionUtils.isNotEmpty((Collection)d.getSubCategories())) {
            for (CategoryDescriptor subCategory : d.getSubCategories()) {
                long subOldId = this.getSettingValue(subCategory.getNameId());
                this.importCategory(subCategory, subOldId, category.getId());
            }
        }
        return category;
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(CATEGORY_CONTEXT, CATEGORY_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(CATEGORY_CONTEXT, CATEGORY_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    private long getAdminGroupIdentityId() {
        if (this.adminGroupOwnerId == 0L) {
            Identity adminGroupIdentity = this.identityManager.getOrCreateGroupIdentity(ADMINISTRATORS_GROUP);
            this.adminGroupOwnerId = adminGroupIdentity == null ? 0L : Long.parseLong(adminGroupIdentity.getId());
        }
        return this.adminGroupOwnerId;
    }

    static {
        CategoryImportService.ajc$preClinit();
        CATEGORY_IMPORT_SCOPE = Scope.APPLICATION.id(CATEGORY_IMPORT);
        CATEGORY_CONTEXT = Context.GLOBAL.id("CATEGORY");
        LOG = ExoLogger.getLogger(CategoryImportService.class);
    }

    static final /* synthetic */ void importDefaultCategories_aroundBody0(CategoryImportService ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.forceReimport && ajc$this.getSettingValue(CATEGORY_VERSION) != ajc$this.categoryImportVersion) {
            ajc$this.forceReimport = true;
        }
        LOG.info("Importing categories with version {}, force reimport = {}", new Object[]{ajc$this.categoryImportVersion, ajc$this.forceReimport});
        try {
            Enumeration<URL> templateFiles = PortalContainer.getInstance().getPortalClassLoader().getResources("default-categories.json");
            Collections.list(templateFiles).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).forEach(ajc$this::importDescriptor);
            LOG.info((Object)"Importing categories finished successfully.");
            LOG.info((Object)"Processing Post categories import");
            ajc$this.categoryTranslationImportService.postImport("category");
            LOG.info((Object)"Processing Post categories import finished");
            ajc$this.setSettingValue(CATEGORY_VERSION, ajc$this.categoryImportVersion);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing categories", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CategoryImportService.java", CategoryImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importDefaultCategories", "io.meeds.social.category.injection.CategoryImportService", "", "", "", "void"), 110);
    }
}

