/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import io.meeds.social.translation.plugin.TranslationPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;

public class SiteTranslationPlugin
extends TranslationPlugin {
    public static final String SITE_OBJECT_TYPE = "site";
    public static final String SITE_DESCRIPTION_FIELD_NAME = "description";
    public static final String SITE_LABEL_FIELD_NAME = "label";
    private LayoutService layoutService;
    private UserACL userACL;

    public SiteTranslationPlugin(LayoutService layoutService, UserACL userACL) {
        this.layoutService = layoutService;
        this.userACL = userACL;
    }

    public String getObjectType() {
        return SITE_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(String siteId, String username) throws ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(Long.parseLong(siteId));
        return this.userACL.hasAccessPermission(portalConfig, this.userACL.getUserIdentity(username));
    }

    public boolean hasEditPermission(String siteId, String username) throws ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(Long.parseLong(siteId));
        return this.userACL.hasEditPermission(portalConfig, this.userACL.getUserIdentity(username));
    }

    public long getAudienceId(String siteId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String siteId) throws ObjectNotFoundException {
        return 0L;
    }
}

