/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.spi.portlet;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.pom.spi.portlet.Preference;

public class Portlet
implements Iterable<Preference>,
Serializable {
    private static final long serialVersionUID = -4571832137663336152L;
    protected Map<String, Preference> state;
    private Map<String, Preference> entries;

    public Portlet() {
        this.state = new HashMap<String, Preference>();
        this.entries = Collections.unmodifiableMap(this.state);
    }

    public Portlet(Map<String, Preference> preferences) {
        this.state = new HashMap<String, Preference>(preferences);
        this.entries = Collections.unmodifiableMap(this.state);
    }

    public List<String> getValues(String name) {
        Preference entry = this.entries.get(name);
        return entry != null ? entry.getValues() : null;
    }

    public Portlet setValues(String name, List<String> values) {
        Preference entry = this.entries.get(name);
        entry = entry == null ? new Preference(name, values, false) : new Preference(entry.getName(), values, entry.isReadOnly());
        this.entries.put(name, entry);
        return this;
    }

    public String getValue(String name) {
        Preference entry = this.entries.get(name);
        return entry != null ? entry.getValue() : null;
    }

    public Portlet setValue(String name, String value) {
        Preference entry = this.entries.get(name);
        entry = entry == null ? new Preference(name, value, false) : new Preference(entry.getName(), value, entry.isReadOnly());
        this.state.put(name, entry);
        return this;
    }

    public Boolean isReadOnly(String name) {
        Preference entry = this.entries.get(name);
        return entry != null ? Boolean.valueOf(entry.isReadOnly()) : null;
    }

    public Portlet setReadOnly(String name, boolean readOnly) {
        Preference entry = this.entries.get(name);
        if (entry == null) {
            throw new IllegalStateException();
        }
        entry = new Preference(entry.getName(), entry.getValues(), readOnly);
        this.state.put(name, entry);
        return this;
    }

    public Preference getPreference(String name) {
        return this.entries.get(name);
    }

    public Portlet putPreference(Preference preference) {
        this.state.put(preference.getName(), preference);
        return this;
    }

    @Override
    public Iterator<Preference> iterator() {
        return this.entries.values().iterator();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Portlet) {
            Portlet that = (Portlet)obj;
            return this.state.equals(that.state);
        }
        return false;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public String toString() {
        return "Preferences[state=" + this.state.toString() + "]";
    }
}

