/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.search;

import io.meeds.social.search.model.SpaceSearchFilter;
import io.meeds.social.search.model.SpaceSearchResult;
import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpaceSearchConnector {
    private static final String PREFIX_COMMA_TO_APPEND = ",%n%s";
    public static final String PERMISSION_FIELD_REDACTOR = "redactor";
    public static final String PERMISSION_FIELD_PUBLISHER = "publisher";
    public static final String PERMISSION_FIELD_INVITED = "invited";
    public static final String PERMISSION_FIELD_PENDING = "pending";
    public static final String PERMISSION_FIELD_MANAGER = "manager";
    public static final String PERMISSION_FIELD_MEMBER = "member";
    public static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static final String SEARCH_COUNT_FILE_PATH_PARAM = "count.file.path";
    private static final Log LOG = ExoLogger.getLogger(SpaceSearchConnector.class);
    private static final String SEARCH_QUERY_TERM = "\"must\":{\n  \"query_string\":{\n    \"fields\": [\"displayName\", \"description\"],\n    \"default_operator\": \"AND\",\n    \"query\": \"@term@~\",\n    \"fuzziness\": 1,\n    \"phrase_slop\": 1\n  }\n},\n";
    private static final String SEARCH_QUERY_WITH_PHRASE = "\"must\":{\n  \"query_string\":{\n    \"fields\": [\"displayName\", \"description\"],\n    \"default_operator\": \"AND\",\n    \"query\": \"(@term@) OR (\\\"@phrase@\\\"~)^5\",\n    \"fuzziness\": 1,\n    \"phrase_slop\": 1\n  }\n},\n";
    public static final String PERMISSIONS_QUERY = "{\n  \"terms\":{\n    \"@permissions_field@\": @permissions@\n  }\n}\n";
    public static final String TEMPLATE_IDS_QUERY = "{\n  \"terms\":{\n    \"templateId\": [@templateIds@]\n  }\n}\n";
    public static final String CATEGORY_INCLUDE_EXCLUDE_QUERY = "{\n  \"bool\": {\n    \"must\": [\n      {\n        \"terms\": {\n          \"categoryId\": [@categoryIds@]\n        }\n      }\n    ],\n    \"must_not\": [\n      {\n        \"terms\": {\n          \"categoryId\": [@excludedCategoryIds@]\n        }\n      }\n    ]\n  }\n}\n";
    public static final String CATEGORY_IDS_QUERY = "{\n  \"terms\":{\n    \"categoryId\": [@categoryIds@]\n  }\n}\n";
    public static final String EXCLUDE_CATEGORY_IDS_QUERY = "{\n  \"bool\": {\n    \"must_not\": [\n      {\n        \"terms\": {\n          \"categoryId\": [@excludedCategoryIds@]\n        }\n      }\n    ]\n  }\n}\n";
    public static final String VISIBILITY_QUERY = "{\n  \"terms\":{\n    \"visibility\": [\"@visibility@\"]\n  }\n}\n";
    public static final String REGISTRATION_QUERY = "{\n  \"terms\":{\n    \"registration\": [\"@registration@\"]\n  }\n}\n";
    public static final String DEFAULT_SORTING_QUERY = "    {\n      \"_score\": {\n        \"order\": \"desc\"\n      }\n    }\n";
    public static final String SORTING_QUERY = "    {\n      \"@sortField@\": {\n        \"order\": \"@sortOrder@\"\n      }\n    },\n    \"_score\"\n";
    private static final String TERM_REPLACEMENT = "@term@";
    private static final String PHRASE_REPLACEMENT = "@phrase@";
    private static final String PERMISSIONS_REPLACEMENT = "@permissions@";
    private static final String PERMISSIONS_FIELD_REPLACEMENT = "@permissions_field@";
    private final ConfigurationManager configurationManager;
    private final ElasticSearchingClient client;
    private String index;
    private String searchQueryFilePath;
    private String countQueryFilePath;
    private String searchQuery;
    private String countQuery;
    private boolean enabled;

    public SpaceSearchConnector(ConfigurationManager configurationManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
        this.searchQuery = this.retrieveQueryFromFile(this.searchQueryFilePath);
        this.countQueryFilePath = initParams.getValueParam(SEARCH_COUNT_FILE_PATH_PARAM).getValue();
        this.countQuery = this.retrieveQueryFromFile(this.countQueryFilePath);
        String enabledParam = param.getProperty("enabled");
        this.enabled = enabledParam == null || StringUtils.equals((CharSequence)enabledParam, (CharSequence)"true");
    }

    public List<SpaceSearchResult> search(SpaceSearchFilter filter, long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)filter.getTerm()) && !filter.isFavorites() && CollectionUtils.isEmpty(filter.getTagNames())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter);
        String esQuery = this.buildQueryStatement(filter, metadataFilters, this.retrieveSearchQuery(), offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    public int count(SpaceSearchFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)filter.getTerm()) && !filter.isFavorites() && CollectionUtils.isEmpty(filter.getTagNames())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter);
        String esQuery = this.buildQueryStatement(filter, metadataFilters, this.retrieveCountQuery(), 0L, 0L);
        String jsonResponse = this.client.countRequest(esQuery, this.index);
        return this.buildCount(jsonResponse);
    }

    private String buildQueryStatement(SpaceSearchFilter filter, Map<String, List<String>> metadataFilters, String query, long offset, long limit) {
        String termQuery = this.buildTermQueryStatement(StringUtils.lowerCase((String)filter.getTerm()));
        String favoriteQuery = this.buildFavoriteQueryStatement(metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
        String templateQuery = this.buildTemplateIdQueryStatement(filter);
        String categoryQuery = this.buildCategoryIdQueryStatement(filter);
        String permissionsQuery = this.buildPermissionsQuery(filter);
        String tagsQuery = this.buildTagsQueryStatement(metadataFilters.get(TagService.METADATA_TYPE.getName()));
        String visibilityQuery = this.buildVisibilityStatement(filter.getVisibility());
        String registrationQuery = this.buildRegistrationStatement(filter.getRegistration());
        String sortQuery = this.buildSortQuery(filter);
        boolean noCommaToTemplate = StringUtils.isBlank((CharSequence)categoryQuery) || StringUtils.isBlank((CharSequence)templateQuery);
        boolean noCommaToFavorite = StringUtils.isBlank((CharSequence)favoriteQuery) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{templateQuery, categoryQuery});
        boolean noCommaToPermission = StringUtils.isBlank((CharSequence)permissionsQuery) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{favoriteQuery, templateQuery, categoryQuery});
        boolean noCommaToVisibility = StringUtils.isBlank((CharSequence)visibilityQuery) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{permissionsQuery, favoriteQuery, templateQuery, categoryQuery});
        boolean noCommaToRegistration = StringUtils.isBlank((CharSequence)registrationQuery) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{visibilityQuery, permissionsQuery, favoriteQuery, templateQuery, categoryQuery});
        return query.replace("@term_query@", termQuery).replace("@category_query@", categoryQuery).replace("@template_query@", noCommaToTemplate ? templateQuery : String.format(PREFIX_COMMA_TO_APPEND, templateQuery)).replace("@favorite_query@", noCommaToFavorite ? favoriteQuery : String.format(PREFIX_COMMA_TO_APPEND, favoriteQuery)).replace("@permissions_query@", noCommaToPermission ? permissionsQuery : String.format(PREFIX_COMMA_TO_APPEND, permissionsQuery)).replace("@visibility_query@", noCommaToVisibility ? visibilityQuery : String.format(PREFIX_COMMA_TO_APPEND, visibilityQuery)).replace("@registration_query@", noCommaToRegistration ? registrationQuery : String.format(PREFIX_COMMA_TO_APPEND, registrationQuery)).replace("@tags_query@", tagsQuery).replace("@sortQuery@", sortQuery).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private String buildRegistrationStatement(SpaceRegistration registration) {
        if (registration == null) {
            return "";
        }
        return REGISTRATION_QUERY.replace("@registration@", StringUtils.lowerCase((String)registration.name()));
    }

    private String buildVisibilityStatement(SpaceVisibility visibility) {
        if (visibility == null) {
            return "";
        }
        return VISIBILITY_QUERY.replace("@visibility@", StringUtils.lowerCase((String)visibility.name()));
    }

    private List<SpaceSearchResult> buildResult(String jsonResponse) {
        Map json;
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return Collections.emptyList();
        }
        ArrayList<SpaceSearchResult> results = new ArrayList<SpaceSearchResult>();
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                SpaceSearchResult spaceSearchResult = new SpaceSearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                Long id = this.parseLong(jsonHitObject, "_id");
                spaceSearchResult.setId(id);
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                if (highlightSource != null) {
                    JSONArray descriptionExcepts;
                    JSONArray nameExcepts = (JSONArray)highlightSource.get((Object)"displayName");
                    if (nameExcepts != null) {
                        String[] nameExceptsArray = (String[])nameExcepts.toArray((Object[])new String[0]);
                        spaceSearchResult.setNameExcerpts(Arrays.asList(nameExceptsArray));
                    }
                    if ((descriptionExcepts = (JSONArray)highlightSource.get((Object)"description")) != null) {
                        String[] descriptionExceptsArray = (String[])descriptionExcepts.toArray((Object[])new String[0]);
                        spaceSearchResult.setDescriptionExcerpts(Arrays.asList(descriptionExceptsArray));
                    }
                }
                results.add(spaceSearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing space search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private int buildCount(String jsonResponse) {
        JSONParser parser = new JSONParser();
        try {
            Map json = (Map)parser.parse(jsonResponse);
            String countString = json.getOrDefault("count", "0").toString();
            return Integer.parseInt(countString);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((CharSequence)this.searchQuery) || PropertyManager.isDevelopping()) {
            this.searchQuery = this.retrieveQueryFromFile(this.searchQueryFilePath);
        }
        return this.searchQuery;
    }

    private String retrieveCountQuery() {
        if (StringUtils.isBlank((CharSequence)this.countQuery) || PropertyManager.isDevelopping()) {
            this.countQuery = this.retrieveQueryFromFile(this.countQueryFilePath);
        }
        return this.countQuery;
    }

    private String retrieveQueryFromFile(String filePath) {
        try {
            InputStream inputStream = this.configurationManager.getInputStream(filePath);
            return IOUtil.getStreamContentAsString((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving search query from file: " + filePath, e);
        }
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replace("'", " ");
        return string;
    }

    private Map<String, List<String>> buildMetadatasFilter(SpaceSearchFilter filter) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filter.isFavorites()) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(String.valueOf(filter.getUserIdentityId())));
        }
        if (CollectionUtils.isNotEmpty(filter.getTagNames())) {
            metadataFilters.put(TagService.METADATA_TYPE.getName(), filter.getTagNames());
        }
        return metadataFilters;
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}}";
    }

    private String buildTagsQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        List<String> tagsQueryParts = values.stream().map(value -> "{\"term\": {\n" + "            \"metadatas.tags.metadataName.keyword\": {\n" + "              \"value\": \"" + value + "\",\n" + "              \"case_insensitive\":true\n" + "            }\n" + "          }}").toList();
        return ",\"should\": [\n" + StringUtils.join(tagsQueryParts, (String)",") + "      ],\n" + "      \"minimum_should_match\": 1";
    }

    private String buildTermQueryStatement(String phrase) {
        if (StringUtils.isBlank((CharSequence)phrase)) {
            return "";
        }
        if (StringUtils.contains((CharSequence)(phrase = this.removeSpecialCharacters(phrase)), (CharSequence)" ")) {
            String terms = Arrays.stream(StringUtils.split((String)phrase, (String)" ")).map(keyword -> {
                String keywordTrim = keyword.trim();
                if (keywordTrim.length() > 4) {
                    return keywordTrim + "~";
                }
                return keywordTrim;
            }).reduce("", (key1, key2) -> key1 + " " + key2);
            return SEARCH_QUERY_WITH_PHRASE.replace(TERM_REPLACEMENT, terms).replace(PHRASE_REPLACEMENT, phrase);
        }
        return SEARCH_QUERY_TERM.replace(TERM_REPLACEMENT, phrase);
    }

    private String buildPermissionsQuery(SpaceSearchFilter filter) {
        if (CollectionUtils.isNotEmpty(filter.getManagingTemplateIds()) && filter.getManagingTemplateIds().contains(0L)) {
            return "";
        }
        String permissionField = this.getPermissionField(filter);
        return PERMISSIONS_QUERY.replace(PERMISSIONS_FIELD_REPLACEMENT, permissionField == null ? "permissions" : permissionField).replace(PERMISSIONS_REPLACEMENT, this.getPermissionFieldValues(permissionField, filter));
    }

    private String getPermissionFieldValues(String permissionField, SpaceSearchFilter filter) {
        String username = filter.getUsername();
        if (CollectionUtils.isNotEmpty(filter.getManagingTemplateIds()) && !username.startsWith("@templateManager@")) {
            String managingTemplatePermissions = StringUtils.join(filter.getManagingTemplateIds().stream().map(id -> String.format("@templateManager@%s", id)).toList(), (String)"\",\"");
            return permissionField == null ? String.format("[\"all\", \"%s\", \"%s\"]", username, managingTemplatePermissions) : String.format("[\"%s\", \"%s\"]", username, managingTemplatePermissions);
        }
        return permissionField == null ? String.format("[\"all\", \"%s\"]", username) : String.format("[\"%s\"]", username);
    }

    private String buildTemplateIdQueryStatement(SpaceSearchFilter filter) {
        if (CollectionUtils.isNotEmpty(filter.getTemplateIds())) {
            return TEMPLATE_IDS_QUERY.replace("@templateIds@", StringUtils.join(filter.getTemplateIds(), (String)","));
        }
        return "";
    }

    private String buildCategoryIdQueryStatement(SpaceSearchFilter filter) {
        ArrayList include = new ArrayList(filter.getCategoryIds() != null ? new ArrayList<Long>(filter.getCategoryIds()) : Collections.emptyList());
        ArrayList<Long> exclude = filter.getExcludedCategoryIds() != null ? new ArrayList<Long>(filter.getExcludedCategoryIds()) : Collections.emptyList();
        include.removeAll(exclude);
        boolean hasInclude = CollectionUtils.isNotEmpty(filter.getCategoryIds());
        boolean hasExclude = CollectionUtils.isNotEmpty(filter.getExcludedCategoryIds());
        if (!hasInclude && !hasExclude) {
            return "";
        }
        if (hasInclude && hasExclude) {
            return CATEGORY_INCLUDE_EXCLUDE_QUERY.replace("@categoryIds@", StringUtils.join(filter.getCategoryIds(), (String)",")).replace("@excludedCategoryIds@", StringUtils.join(filter.getExcludedCategoryIds(), (String)","));
        }
        if (hasInclude) {
            return CATEGORY_IDS_QUERY.replace("@categoryIds@", StringUtils.join(filter.getCategoryIds(), (String)","));
        }
        return EXCLUDE_CATEGORY_IDS_QUERY.replace("@excludedCategoryIds@", StringUtils.join(filter.getExcludedCategoryIds(), (String)","));
    }

    private String getPermissionField(SpaceSearchFilter filter) {
        if (filter.isFavorites()) {
            return PERMISSION_FIELD_MEMBER;
        }
        SpaceMembershipStatus status = filter.getStatus();
        if (status == null) {
            return null;
        }
        return switch (status) {
            case SpaceMembershipStatus.MEMBER -> PERMISSION_FIELD_MEMBER;
            case SpaceMembershipStatus.MANAGER -> PERMISSION_FIELD_MANAGER;
            case SpaceMembershipStatus.PENDING -> PERMISSION_FIELD_PENDING;
            case SpaceMembershipStatus.INVITED -> PERMISSION_FIELD_INVITED;
            case SpaceMembershipStatus.PUBLISHER -> PERMISSION_FIELD_PUBLISHER;
            case SpaceMembershipStatus.REDACTOR -> PERMISSION_FIELD_REDACTOR;
            default -> null;
        };
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String buildSortQuery(SpaceSearchFilter filter) {
        if (StringUtils.isBlank((CharSequence)filter.getSortField())) {
            return DEFAULT_SORTING_QUERY;
        }
        String sortFiled = filter.getSortField();
        String sortDirection = filter.getSortDirection();
        return switch (sortFiled) {
            case "date" -> SORTING_QUERY.replace("@sortField@", "lastUpdatedDate").replace("@sortOrder@", sortDirection);
            default -> DEFAULT_SORTING_QUERY;
        };
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }
}

