/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.endpoints;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.DelegatingJsonGenerator;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.endpoints.EndpointBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

public class SimpleEndpoint<RequestT, ResponseT>
extends EndpointBase<RequestT, ResponseT>
implements JsonEndpoint<RequestT, ResponseT, ErrorResponse> {
    private final JsonpDeserializer<ResponseT> responseParser;

    public SimpleEndpoint(String id, Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> pathParameters, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, Function<RequestT, Object> body, JsonpDeserializer<ResponseT> responseParser) {
        super(id, method, requestUrl, pathParameters, queryParameters, headers, body);
        this.responseParser = responseParser;
    }

    public SimpleEndpoint(String id, Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> pathParameters, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, boolean hasRequestBody, JsonpDeserializer<ResponseT> responseParser) {
        this(id, method, requestUrl, pathParameters, queryParameters, headers, hasRequestBody ? SimpleEndpoint.returnSelf() : SimpleEndpoint.returnNull(), responseParser);
    }

    @Override
    public JsonpDeserializer<ResponseT> responseDeserializer() {
        return this.responseParser;
    }

    @Override
    public <NewResponseT> SimpleEndpoint<RequestT, NewResponseT> withResponseDeserializer(JsonpDeserializer<NewResponseT> newResponseParser) {
        return new SimpleEndpoint<RequestT, NewResponseT>(this.id, this.method, this.requestUrl, this.pathParameters, this.queryParameters, this.headers, this.body, newResponseParser);
    }

    public static <T, U extends JsonpSerializable> Function<T, Object> nonEmptyJsonObject(Function<T, U> getter) {
        return x -> x == null ? null : new NonEmptySerializable(getter.apply(x));
    }

    private static final class NonEmptySerializable
    implements JsonpSerializable {
        private final Object value;

        NonEmptySerializable(Object value) {
            this.value = value;
        }

        @Override
        public void serialize(JsonGenerator generator, JsonpMapper mapper) {
            DelegatingJsonGenerator filter = new DelegatingJsonGenerator(generator){
                boolean gotKey;
                {
                    super(generator);
                    this.gotKey = false;
                }

                @Override
                public JsonGenerator writeStartObject() {
                    if (this.gotKey) {
                        super.writeStartObject();
                    }
                    return this;
                }

                @Override
                public JsonGenerator writeKey(String s) {
                    if (!this.gotKey) {
                        this.gotKey = true;
                        super.writeStartObject();
                    }
                    super.writeKey(s);
                    return this;
                }

                @Override
                public JsonGenerator writeEnd() {
                    if (this.gotKey) {
                        super.writeEnd();
                    }
                    return this;
                }
            };
            mapper.serialize(this.value, filter);
        }
    }
}

