/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortalHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private String redirectLocation;
    private List<Map.Entry<String, String>> addedHeaders = new ArrayList<Map.Entry<String, String>>();
    private Map<String, String> settedHeaders = new HashMap<String, String>();
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private boolean isError = false;
    private int error = 0;
    private String errorMsg = null;
    private boolean wrapMethods = false;
    private HttpServletResponse response;

    public PortalHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.wrapMethods) {
            this.redirectLocation = location;
        } else {
            super.sendRedirect(location);
        }
    }

    public void setHeader(String name, String value) {
        if (this.wrapMethods) {
            this.settedHeaders.put(name, value);
        } else {
            super.setHeader(name, value);
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.wrapMethods) {
            this.cookies.add(cookie);
        } else {
            super.addCookie(cookie);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.wrapMethods) {
            this.isError = true;
            this.error = sc;
            this.errorMsg = msg;
        } else {
            super.sendError(sc, msg);
        }
    }

    public void sendError(int sc) throws IOException {
        if (this.wrapMethods) {
            this.isError = true;
            this.error = sc;
        } else {
            super.sendError(sc);
        }
    }

    public void addHeader(String name, String value, boolean wrapMethods) {
        if (wrapMethods) {
            this.addHeader(name, value);
        } else {
            this.response.addHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (this.wrapMethods) {
            this.addedHeaders.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        } else {
            super.addHeader(name, value);
        }
    }

    public boolean isWrapMethods() {
        return this.wrapMethods;
    }

    public void setWrapMethods(boolean wrapMethods) {
        this.wrapMethods = wrapMethods;
    }

    public void commit() throws IOException {
        if (!this.wrapMethods) {
            return;
        }
        if (!this.addedHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.addedHeaders) {
                this.response.addHeader(entry.getKey(), entry.getValue());
            }
            this.addedHeaders.clear();
        }
        if (!this.settedHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.settedHeaders.entrySet()) {
                this.response.setHeader(entry.getKey(), entry.getValue());
            }
            this.settedHeaders.clear();
        }
        if (!this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.response.addCookie(cookie);
            }
            this.cookies.clear();
        }
        if (this.isError) {
            if (this.errorMsg == null) {
                this.response.sendError(this.error);
            } else {
                this.response.sendError(this.error, this.errorMsg);
            }
            this.isError = false;
        } else if (this.redirectLocation != null) {
            this.response.sendRedirect(this.redirectLocation);
            this.redirectLocation = null;
        }
    }
}

