/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Converter
public class StringMapConverter
implements AttributeConverter<Map<String, String>, String> {
    private static final String DELIMITER = "\n";

    public String convertToDatabaseColumn(Map<String, String> attributes) {
        return attributes != null ? StringUtils.join(attributes.entrySet().stream().map(e -> "%s=%s".formatted(e.getKey(), e.getValue())).toList(), (String)DELIMITER) : null;
    }

    public Map<String, String> convertToEntityAttribute(String dbData) {
        return dbData != null ? Arrays.stream(dbData.split(DELIMITER)).filter(StringUtils::isNotBlank).collect(Collectors.toMap(v -> v.substring(0, v.indexOf("=")), v -> v.substring(v.indexOf("=") + 1))) : null;
    }
}

