/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.util.MissingRequiredPropertyException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ApiTypeHelper {
    private static final ThreadLocal<Boolean> disableRequiredPropertiesCheck = new ThreadLocal();
    static final List<Object> UNDEFINED_LIST = new EmptyList();
    static final Map<Object, Object> UNDEFINED_MAP = new EmptyMap();

    private ApiTypeHelper() {
    }

    public static boolean requiredPropertiesCheckDisabled() {
        return disableRequiredPropertiesCheck.get() == Boolean.TRUE;
    }

    public static DisabledChecksHandle DANGEROUS_disableRequiredPropertiesCheck(boolean disable) {
        DisabledChecksHandle result = new DisabledChecksHandle(disableRequiredPropertiesCheck.get());
        disableRequiredPropertiesCheck.set(disable);
        return result;
    }

    public static <T> T requireNonNull(T value, Object obj, String name) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value;
    }

    private static <T> void checkNotNull(T value, Object obj, String name) {
        if (value == null && !ApiTypeHelper.requiredPropertiesCheckDisabled()) {
            throw new MissingRequiredPropertyException(obj, name);
        }
    }

    public static <T> T requireNonNull(T value, Object obj, String name, T defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value;
    }

    public static int requireNonNull(Integer value, Object obj, String name, int defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value;
    }

    public static double requireNonNull(Double value, Object obj, String name, double defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value;
    }

    public static long requireNonNull(Long value, Object obj, String name, long defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value;
    }

    public static float requireNonNull(Float value, Object obj, String name, float defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value.floatValue();
    }

    public static boolean requireNonNull(Boolean value, Object obj, String name, boolean defaultValue) {
        ApiTypeHelper.checkNotNull(value, obj, name);
        return value == null ? defaultValue : value;
    }

    public static <T> List<T> undefinedList() {
        return UNDEFINED_LIST;
    }

    public static <T> boolean isDefined(List<T> list) {
        return list != null && list != UNDEFINED_LIST;
    }

    public static <T> List<T> unmodifiable(@Nullable List<T> list) {
        if (list == null) {
            return ApiTypeHelper.undefinedList();
        }
        if (list == UNDEFINED_LIST) {
            return list;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> unmodifiableRequired(List<T> list, Object obj, String name) {
        ApiTypeHelper.requireNonNull(list == UNDEFINED_LIST ? null : list, obj, name);
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> undefinedMap() {
        return UNDEFINED_MAP;
    }

    public static <K, V> boolean isDefined(Map<K, V> map) {
        return map != null && map != UNDEFINED_MAP;
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        if (map == null) {
            return ApiTypeHelper.undefinedMap();
        }
        if (map == UNDEFINED_MAP) {
            return map;
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableRequired(Map<K, V> map, Object obj, String name) {
        ApiTypeHelper.requireNonNull(map == UNDEFINED_MAP ? null : map, obj, name);
        return Collections.unmodifiableMap(map);
    }

    public static class DisabledChecksHandle
    implements AutoCloseable {
        private final Boolean value;

        public DisabledChecksHandle(Boolean value) {
            this.value = value;
        }

        @Override
        public void close() {
            disableRequiredPropertiesCheck.set(this.value);
        }
    }

    static class EmptyList
    extends AbstractList<Object> {
        EmptyList() {
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    }

    static class EmptyMap
    extends AbstractMap<Object, Object> {
        EmptyMap() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

