/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.lang.Nullable;

class WebfluxCodecCustomizer
implements Consumer<Object> {
    private static final MediaType ANY_JSON = MediaType.parseMediaType((String)"application/*+json");
    private final List<HypermediaMappingInformation> mappingInformations;
    private final ObjectMapper mapper;
    private final boolean withGenericJsonTypes;

    public WebfluxCodecCustomizer(List<HypermediaMappingInformation> mappingInformations, ObjectMapper mapper) {
        this(mappingInformations, mapper, false);
    }

    private WebfluxCodecCustomizer(List<HypermediaMappingInformation> mappingInformations, ObjectMapper mapper, boolean withGenericJsonTypes) {
        this.mappingInformations = mappingInformations;
        this.mapper = mapper;
        this.withGenericJsonTypes = withGenericJsonTypes;
    }

    WebfluxCodecCustomizer withGenericJsonTypes() {
        return new WebfluxCodecCustomizer(this.mappingInformations, this.mapper, true);
    }

    @Override
    public void accept(@Nullable Object it) {
        if (it == null || !Jackson2CodecSupport.class.isInstance(it)) {
            return;
        }
        Jackson2CodecSupport codec = (Jackson2CodecSupport)it;
        ObjectMapper firstMapper = null;
        for (HypermediaMappingInformation information : this.mappingInformations) {
            ObjectMapper objectMapper = information.configureObjectMapper(this.mapper.copy());
            if (firstMapper == null) {
                firstMapper = objectMapper;
            }
            for (MediaType mediaType : information.getMediaTypes()) {
                codec.registerObjectMappersForType(information.getRootType(), map -> map.put(mediaType, objectMapper));
            }
        }
        if (!this.withGenericJsonTypes) {
            return;
        }
        Class<?> type = this.mappingInformations.get(0).getRootType();
        ObjectMapper mapper = firstMapper;
        codec.registerObjectMappersForType(type, map -> Stream.of(MediaType.APPLICATION_JSON, ANY_JSON).forEach(mediaType -> map.put(mediaType, mapper)));
    }
}

