/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.entity.ProgramEntity;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import lombok.Generated;

@Entity(name="Rule")
@Table(name="GAMIFICATION_RULE")
@NamedQueries(value={@NamedQuery(name="Rule.findActiveRuleByEventAndDomain", query="SELECT rule FROM Rule rule WHERE LOWER(rule.eventEntity.title) = LOWER(:event) AND rule.domainEntity.id = :domainId AND rule.isEnabled = true AND rule.isDeleted = false AND (rule.startDate IS NULL OR rule.startDate <= :date) AND (rule.endDate IS NULL OR rule.endDate > :date) AND rule.type = :type"), @NamedQuery(name="Rule.findRuleByTitle", query="SELECT rule FROM Rule rule WHERE LOWER(rule.title) = LOWER(:ruleTitle) AND rule.type = :type"), @NamedQuery(name="Rule.getRulesTotalScoreByDomain", query=" SELECT SUM(rule.score) FROM Rule rule  WHERE rule.domainEntity.id = :domainId AND rule.isEnabled = true AND rule.isDeleted = false AND (rule.startDate IS NULL OR rule.startDate <= :date) AND (rule.endDate IS NULL OR rule.endDate > :date)"), @NamedQuery(name="Rule.getHighestBudgetDomainIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC"), @NamedQuery(name="Rule.getHighestBudgetOpenDomainIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false  AND domain.audienceId IS NULL WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC"), @NamedQuery(name="Rule.getHighestBudgetDomainIdsBySpacesIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false  AND (domain.audienceId IS NULL OR domain.audienceId in (:spacesIds)) WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC")})
public class RuleEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_RULE_ID", sequenceName="SEQ_GAMIFICATION_RULE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_RULE_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="SCORE")
    protected int score;
    @Column(name="ACTIVITY_ID")
    protected long activityId;
    @ManyToOne
    @JoinColumn(name="EVENT_ID")
    private EventEntity eventEntity;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private ProgramEntity domainEntity;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="END_DATE")
    private Date endDate;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    protected EntityType type;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="RECURRENCE", nullable=false)
    private RecurrenceType recurrence;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GAMIFICATION_PREREQUISITE_RULES", joinColumns={@JoinColumn(name="RULE_ID")})
    @Column(name="PREREQUISITE_RULE_ID")
    private Set<Long> prerequisiteRules;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="DEFAULT_REALIZATION_STATUS", nullable=false)
    protected RealizationStatus defaultRealizationStatus;

    @Generated
    public RuleEntity() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getScore() {
        return this.score;
    }

    @Generated
    public long getActivityId() {
        return this.activityId;
    }

    @Generated
    public EventEntity getEventEntity() {
        return this.eventEntity;
    }

    @Generated
    public ProgramEntity getDomainEntity() {
        return this.domainEntity;
    }

    @Generated
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Generated
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public Date getEndDate() {
        return this.endDate;
    }

    @Generated
    public EntityType getType() {
        return this.type;
    }

    @Generated
    public RecurrenceType getRecurrence() {
        return this.recurrence;
    }

    @Generated
    public Set<Long> getPrerequisiteRules() {
        return this.prerequisiteRules;
    }

    @Generated
    public RealizationStatus getDefaultRealizationStatus() {
        return this.defaultRealizationStatus;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setScore(int score) {
        this.score = score;
    }

    @Generated
    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setEventEntity(EventEntity eventEntity) {
        this.eventEntity = eventEntity;
    }

    @Generated
    public void setDomainEntity(ProgramEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    @Generated
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setType(EntityType type) {
        this.type = type;
    }

    @Generated
    public void setRecurrence(RecurrenceType recurrence) {
        this.recurrence = recurrence;
    }

    @Generated
    public void setPrerequisiteRules(Set<Long> prerequisiteRules) {
        this.prerequisiteRules = prerequisiteRules;
    }

    @Generated
    public void setDefaultRealizationStatus(RealizationStatus defaultRealizationStatus) {
        this.defaultRealizationStatus = defaultRealizationStatus;
    }

    @Override
    @Generated
    public String toString() {
        return "RuleEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", score=" + this.getScore() + ", activityId=" + this.getActivityId() + ", eventEntity=" + String.valueOf(this.getEventEntity()) + ", domainEntity=" + String.valueOf(this.getDomainEntity()) + ", isEnabled=" + this.isEnabled() + ", isDeleted=" + this.isDeleted() + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", type=" + String.valueOf((Object)this.getType()) + ", recurrence=" + String.valueOf((Object)this.getRecurrence()) + ", prerequisiteRules=" + String.valueOf(this.getPrerequisiteRules()) + ", defaultRealizationStatus=" + String.valueOf((Object)this.getDefaultRealizationStatus()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEntity)) {
            return false;
        }
        RuleEntity other = (RuleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        if (this.getActivityId() != other.getActivityId()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        EventEntity this$eventEntity = this.getEventEntity();
        EventEntity other$eventEntity = other.getEventEntity();
        if (this$eventEntity == null ? other$eventEntity != null : !((Object)this$eventEntity).equals(other$eventEntity)) {
            return false;
        }
        ProgramEntity this$domainEntity = this.getDomainEntity();
        ProgramEntity other$domainEntity = other.getDomainEntity();
        if (this$domainEntity == null ? other$domainEntity != null : !((Object)this$domainEntity).equals(other$domainEntity)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RecurrenceType this$recurrence = this.getRecurrence();
        RecurrenceType other$recurrence = other.getRecurrence();
        if (this$recurrence == null ? other$recurrence != null : !((Object)((Object)this$recurrence)).equals((Object)other$recurrence)) {
            return false;
        }
        Set<Long> this$prerequisiteRules = this.getPrerequisiteRules();
        Set<Long> other$prerequisiteRules = other.getPrerequisiteRules();
        if (this$prerequisiteRules == null ? other$prerequisiteRules != null : !((Object)this$prerequisiteRules).equals(other$prerequisiteRules)) {
            return false;
        }
        RealizationStatus this$defaultRealizationStatus = this.getDefaultRealizationStatus();
        RealizationStatus other$defaultRealizationStatus = other.getDefaultRealizationStatus();
        return !(this$defaultRealizationStatus == null ? other$defaultRealizationStatus != null : !((Object)((Object)this$defaultRealizationStatus)).equals((Object)other$defaultRealizationStatus));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getScore();
        long $activityId = this.getActivityId();
        result = result * 59 + (int)($activityId >>> 32 ^ $activityId);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        EventEntity $eventEntity = this.getEventEntity();
        result = result * 59 + ($eventEntity == null ? 43 : ((Object)$eventEntity).hashCode());
        ProgramEntity $domainEntity = this.getDomainEntity();
        result = result * 59 + ($domainEntity == null ? 43 : ((Object)$domainEntity).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RecurrenceType $recurrence = this.getRecurrence();
        result = result * 59 + ($recurrence == null ? 43 : ((Object)((Object)$recurrence)).hashCode());
        Set<Long> $prerequisiteRules = this.getPrerequisiteRules();
        result = result * 59 + ($prerequisiteRules == null ? 43 : ((Object)$prerequisiteRules).hashCode());
        RealizationStatus $defaultRealizationStatus = this.getDefaultRealizationStatus();
        result = result * 59 + ($defaultRealizationStatus == null ? 43 : ((Object)((Object)$defaultRealizationStatus)).hashCode());
        return result;
    }
}

