/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.listener;

import io.meeds.content.news.model.News;
import io.meeds.content.news.model.NewsPageObject;
import io.meeds.content.news.service.NewsService;
import io.meeds.content.news.utils.NewsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(NewsActivityListener.class);
    private static final String NEWS_ID = "newsId";
    private static final String NEWS_ACTIVITY_TYPE = "news";
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private NewsService newsService;
    @Autowired
    private MetadataService metadataService;

    @PostConstruct
    public void init() {
        this.activityManager.addActivityEventListener((ActivityListenerPlugin)this);
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        String originalActivityId;
        ExoSocialActivity originalActivity;
        ExoSocialActivity sharedActivity = event.getActivity();
        if (sharedActivity != null && sharedActivity.getTemplateParams() != null && sharedActivity.getTemplateParams().containsKey("originalActivityId") && (originalActivity = this.activityManager.getActivity(originalActivityId = (String)sharedActivity.getTemplateParams().get("originalActivityId"))) != null && originalActivity.getTemplateParams() != null && originalActivity.getTemplateParams().containsKey(NEWS_ID)) {
            String newsId = (String)originalActivity.getTemplateParams().get(NEWS_ID);
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsById(newsId, currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
                if (news != null && !news.isDeleted()) {
                    org.exoplatform.social.core.identity.model.Identity posterIdentity = this.getIdentity(sharedActivity);
                    Space space = this.getSpace(sharedActivity);
                    this.newsService.shareNews(news, space, posterIdentity, sharedActivity.getId());
                }
            }
            catch (Exception e) {
                LOG.error("Error while sharing news {} to activity {}", new Object[]{newsId, sharedActivity.getId(), e});
            }
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = this.activityManager.getActivity(event.getActivity().getId());
        if (activity != null && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey(NEWS_ID)) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsByActivityId(activity.getId(), currentIdentity);
                NewsUtils.broadcastEvent("exo.news.likeArticle", currentIdentity.getUserId(), news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error broadcast like news event", (Throwable)e);
            }
        }
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = this.activityManager.getActivity(event.getActivity().getParentId());
        if (activity != null && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey(NEWS_ID)) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsByActivityId(activity.getId(), currentIdentity);
                NewsUtils.broadcastEvent("exo.news.commentArticle", currentIdentity.getUserId(), news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error broadcast comment news event", (Throwable)e);
            }
        }
    }

    public void hideActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = event.getActivity();
        if (activity != null && activity.getType().equals(NEWS_ACTIVITY_TYPE) && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey(NEWS_ID)) {
            this.updateNewsPageMetadataObjectItem(activity);
        }
    }

    private org.exoplatform.social.core.identity.model.Identity getIdentity(ExoSocialActivity sharedActivity) {
        String posterIdentityId = sharedActivity.getPosterId();
        return this.identityManager.getIdentity(posterIdentityId);
    }

    private Space getSpace(ExoSocialActivity sharedActivity) {
        String spacePrettyName = sharedActivity.getActivityStream().getPrettyId();
        return this.spaceService.getSpaceByPrettyName(spacePrettyName);
    }

    private String getCurrentIdentityId() {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity currentIdentity = null;
        if (conversationState != null) {
            currentIdentity = conversationState.getIdentity();
        }
        if (currentIdentity != null) {
            return this.identityManager.getOrCreateUserIdentity(currentIdentity.getUserId()).getId();
        }
        return null;
    }

    private void updateNewsPageMetadataObjectItem(ExoSocialActivity activity) {
        Map properties;
        String newsId = (String)activity.getTemplateParams().get(NEWS_ID);
        String spaceId = activity.getSpaceId();
        String currentIdentityId = this.getCurrentIdentityId();
        long updater = currentIdentityId != null ? Long.parseLong(currentIdentityId) : Long.parseLong(activity.getPosterId());
        NewsPageObject newsPageObject = new NewsPageObject("newsPage", newsId, null, Long.parseLong(spaceId));
        MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NewsService.NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
        if (metadataItem != null && (properties = metadataItem.getProperties()).containsKey("activityPosted") && properties.get("activityPosted") != null && Boolean.parseBoolean((String)properties.get("activityPosted"))) {
            properties.put("activityPosted", String.valueOf(false));
            metadataItem.setProperties(properties);
            this.metadataService.updateMetadataItem(metadataItem, updater, false);
        }
    }
}

