/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeChangeNotifier<N>
implements NodeChangeListener<NodeContext<N>> {
    private static final Log LOG = ExoLogger.getLogger(NodeChangeNotifier.class);
    private NodeChangeListener<NodeContext<N>> listener;
    private ListenerService listenerService;
    private NavigationService navigationService;

    public NodeChangeNotifier(NodeChangeListener<NodeContext<N>> listener, NavigationService navigationService, ListenerService listenerService) {
        this.listener = listener;
        this.listenerService = listenerService;
        this.navigationService = navigationService;
    }

    @Override
    public void onAdd(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_add", target);
        if (this.listener != null) {
            this.listener.onAdd(target, parent, previous);
        }
    }

    @Override
    public void onCreate(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous, String name) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_create", target);
        if (this.listener != null) {
            this.listener.onCreate(target, parent, previous, name);
        }
    }

    @Override
    public void onRemove(NodeContext<N> target, NodeContext<N> parent) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_remove", target);
        if (this.listener != null) {
            this.listener.onRemove(target, parent);
        }
    }

    @Override
    public void onDestroy(NodeContext<N> target, NodeContext<N> parent) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_destroy", target);
        if (this.listener != null) {
            this.listener.onDestroy(target, parent);
        }
    }

    @Override
    public void onRename(NodeContext<N> target, NodeContext<N> parent, String name) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_rename", target);
        if (this.listener != null) {
            this.listener.onRename(target, parent, name);
        }
    }

    @Override
    public void onUpdate(NodeContext<N> target, NodeState state) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_update", target);
        if (this.listener != null) {
            this.listener.onUpdate(target, state);
        }
    }

    @Override
    public void onMove(NodeContext<N> target, NodeContext<N> from, NodeContext<N> to, NodeContext<N> previous) {
        this.notifyNodeChange("org.exoplatform.portal.mop.navigation.node_move", target);
        if (this.listener != null) {
            this.listener.onMove(target, from, to, previous);
        }
    }

    private void notifyNodeChange(String eventName, NodeContext<N> target) {
        try {
            LOG.debug((Object)("Broadcasting change type " + eventName + " notification for node " + target.getId() + " name " + target.getName()));
            this.listenerService.broadcast(eventName, (Object)this.navigationService, target);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when delivering notification " + eventName + " for node " + target.getId()), (Throwable)e);
        }
    }
}

