/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.user.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "user";
    @Autowired
    private PortalContainer container;
    private UserACL userAcl;

    @PostConstruct
    public void init() {
        this.userAcl = (UserACL)this.container.getComponentInstanceOfType(UserACL.class);
        this.userAcl.addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        if (identity == null) {
            return false;
        }
        Identity userIdentity = this.userAcl.getUserIdentity(objectId);
        if (userIdentity == null) {
            return "DELETE".equals(permissionType) ? this.userAcl.isSuperUser(identity) : this.userAcl.isAdministrator(identity);
        }
        return switch (permissionType) {
            case "DELETE" -> this.userAcl.isSuperUser(identity);
            case "VIEW" -> {
                if (this.userAcl.isAdministrator(identity) || userIdentity.getGroups().stream().filter(g -> !"/platform/externals".equals(g)).anyMatch(g -> identity.getGroups().contains(g))) {
                    yield true;
                }
                yield false;
            }
            default -> this.userAcl.isAdministrator(identity);
        };
    }
}

