/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;

public class IdentityProviderPlugin
extends BaseComponentPlugin {
    List<IdentityProvider<?>> providers = new ArrayList();
    private static Log LOG = ExoLogger.getExoLogger(IdentityProviderPlugin.class);

    public IdentityProviderPlugin(InitParams initParams) {
        ValuesParam values = initParams.getValuesParam("providers");
        if (values == null) {
            LOG.warn((Object)"Missing expected <values-param>. : providers");
            return;
        }
        List classes = values.getValues();
        for (String className : classes) {
            try {
                Class<?> t = Class.forName(className);
                if (IdentityProvider.class.isAssignableFrom(t)) {
                    IdentityProvider provider = (IdentityProvider)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(t);
                    if (provider != null) {
                        this.providers.add(provider);
                        continue;
                    }
                    LOG.warn((Object)("No component of type " + className + " found in ExoContainer"));
                    continue;
                }
                LOG.warn((Object)(className + " must be of type " + String.valueOf(IdentityProvider.class)));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to instanciate provider of type " + className), (Throwable)e);
            }
        }
    }

    public List<IdentityProvider<?>> getProviders() {
        return this.providers;
    }
}

