/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MappingStats
implements JsonpSerializable {
    private final long totalCount;
    @Nullable
    private final String totalEstimatedOverhead;
    private final long totalEstimatedOverheadInBytes;
    public static final JsonpDeserializer<MappingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MappingStats::setupMappingStatsDeserializer);

    private MappingStats(Builder builder) {
        this.totalCount = ApiTypeHelper.requireNonNull(builder.totalCount, (Object)this, "totalCount", 0L);
        this.totalEstimatedOverhead = builder.totalEstimatedOverhead;
        this.totalEstimatedOverheadInBytes = ApiTypeHelper.requireNonNull(builder.totalEstimatedOverheadInBytes, (Object)this, "totalEstimatedOverheadInBytes", 0L);
    }

    public static MappingStats of(Function<Builder, ObjectBuilder<MappingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long totalCount() {
        return this.totalCount;
    }

    @Nullable
    public final String totalEstimatedOverhead() {
        return this.totalEstimatedOverhead;
    }

    public final long totalEstimatedOverheadInBytes() {
        return this.totalEstimatedOverheadInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_count");
        generator.write(this.totalCount);
        if (this.totalEstimatedOverhead != null) {
            generator.writeKey("total_estimated_overhead");
            generator.write(this.totalEstimatedOverhead);
        }
        generator.writeKey("total_estimated_overhead_in_bytes");
        generator.write(this.totalEstimatedOverheadInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMappingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count");
        op.add(Builder::totalEstimatedOverhead, JsonpDeserializer.stringDeserializer(), "total_estimated_overhead");
        op.add(Builder::totalEstimatedOverheadInBytes, JsonpDeserializer.longDeserializer(), "total_estimated_overhead_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MappingStats> {
        private Long totalCount;
        @Nullable
        private String totalEstimatedOverhead;
        private Long totalEstimatedOverheadInBytes;

        public final Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        public final Builder totalEstimatedOverhead(@Nullable String value) {
            this.totalEstimatedOverhead = value;
            return this;
        }

        public final Builder totalEstimatedOverheadInBytes(long value) {
            this.totalEstimatedOverheadInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MappingStats build() {
            this._checkSingleUse();
            return new MappingStats(this);
        }
    }
}

