/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;

class Codec {
    private static final char[][] table = new char[256][];

    private Codec() {
    }

    public static String decode(String s) {
        try {
            s = s.replace("_", "%2F");
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static void encode(Appendable appendable, String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) {
                appendable.append(c);
                continue;
            }
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case 'A': {
                    appendable.append(c);
                    continue block5;
                }
                case ' ': {
                    appendable.append('+');
                    continue block5;
                }
                case '/': {
                    appendable.append('_');
                    continue block5;
                }
                default: {
                    CharEncoder encoder = CharsetCharEncoder.getUTF8();
                    byte[] bytes = encoder.encode(c);
                    appendable.append('%');
                    for (byte b : bytes) {
                        for (char cc : table[b]) {
                            appendable.append(cc);
                        }
                    }
                }
            }
        }
    }

    static {
        char[] a = "0123456789ABCDEF".toCharArray();
        for (int b = 0; b < 256; ++b) {
            int b1 = (b & 0xF0) >> 4;
            int b2 = b & 0xF;
            Codec.table[b] = new char[]{a[b1], a[b2]};
        }
    }
}

