/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.crypto;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.crypto.RsaProvider;
import io.jsonwebtoken.impl.crypto.Signer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAKey;

public class RsaSigner
extends RsaProvider
implements Signer {
    public RsaSigner(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        if (!(key instanceof PrivateKey) || !(key instanceof RSAKey)) {
            String msg = "RSA signatures must be computed using an RSA PrivateKey.  The specified key of type " + key.getClass().getName() + " is not an RSA PrivateKey.";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            return this.doSign(data);
        }
        catch (InvalidKeyException e) {
            throw new io.jsonwebtoken.security.SignatureException("Invalid RSA PrivateKey. " + e.getMessage(), (Throwable)e);
        }
        catch (SignatureException e) {
            throw new io.jsonwebtoken.security.SignatureException("Unable to calculate signature using RSA PrivateKey. " + e.getMessage(), (Throwable)e);
        }
    }

    protected byte[] doSign(byte[] data) throws InvalidKeyException, SignatureException {
        PrivateKey privateKey = (PrivateKey)this.key;
        Signature sig = this.createSignatureInstance();
        sig.initSign(privateKey);
        sig.update(data);
        return sig.sign();
    }
}

