/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.media;

import java.util.Locale;

public final class SubtypeDef {
    public static final SubtypeDef HTML = new SubtypeDef("html");
    public static final SubtypeDef XML = new SubtypeDef("xml");
    public static final SubtypeDef CSS = new SubtypeDef("css");
    public static final SubtypeDef PLAIN = new SubtypeDef("plain");
    public static final SubtypeDef JAVASCRIPT = new SubtypeDef("javascript");
    public static final SubtypeDef X_WWW_FORM_URLENCODED = new SubtypeDef("x-www-form-urlencoded");
    public static final SubtypeDef FORM_DATA = new SubtypeDef("form-data");
    private final String name;
    private volatile String toString;

    public static SubtypeDef create(String subtypeName) throws IllegalArgumentException {
        if (subtypeName == null) {
            throw new IllegalArgumentException("No null subtype name accepted");
        }
        if (subtypeName.length() == 0) {
            throw new IllegalArgumentException("No empty subtype name accepted");
        }
        return new SubtypeDef(subtypeName);
    }

    SubtypeDef(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No null name allowed");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubtypeDef) {
            SubtypeDef that = (SubtypeDef)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "SubtypeDef[" + this.name + "]";
        }
        return this.toString;
    }
}

