/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.ui;

import java.nio.charset.Charset;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.ui.HtmlTemplates;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public final class OneTimeTokenSubmitPageGeneratingWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher matcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/login/ott");
    private String loginProcessingUrl = "/login/ott";
    private static final String ONE_TIME_TOKEN_SUBMIT_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <title>One-Time Token Login</title>\n    <meta charset=\"utf-8\"/>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\"/>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n    <div class=\"container\">\n      <form class=\"login-form\" action=\"{{loginProcessingUrl}}\" method=\"post\">\n        <h2>Please input the token</h2>\n        <p>\n          <label for=\"token\" class=\"screenreader\">Token</label>\n          <input type=\"text\" id=\"token\" name=\"token\" value=\"{{tokenValue}}\" placeholder=\"Token\" required=\"true\" autofocus=\"autofocus\"/>\n        </p>\n{{csrf}}\n        <button class=\"primary\" type=\"submit\">Sign in</button>\n      </form>\n    </div>\n  </body>\n</html>\n";
    private static final String CSRF_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> this.render(exchange));
    }

    private Mono<Void> render(ServerWebExchange exchange) {
        ServerHttpResponse result = exchange.getResponse();
        result.setStatusCode((HttpStatusCode)HttpStatus.OK);
        result.getHeaders().setContentType(MediaType.TEXT_HTML);
        return result.writeWith(this.createBuffer(exchange));
    }

    private Mono<DataBuffer> createBuffer(ServerWebExchange exchange) {
        Mono token = (Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty());
        return token.map(OneTimeTokenSubmitPageGeneratingWebFilter::csrfToken).defaultIfEmpty((Object)"").map(csrfTokenHtmlInput -> {
            byte[] bytes = this.createPage(exchange, (String)csrfTokenHtmlInput);
            DataBufferFactory bufferFactory = exchange.getResponse().bufferFactory();
            return bufferFactory.wrap(bytes);
        });
    }

    private byte[] createPage(ServerWebExchange exchange, String csrfTokenHtmlInput) {
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        String token = (String)queryParams.getFirst((Object)"token");
        String tokenValue = StringUtils.hasText((String)token) ? token : "";
        String contextPath = exchange.getRequest().getPath().contextPath().value();
        return HtmlTemplates.fromTemplate(ONE_TIME_TOKEN_SUBMIT_PAGE_TEMPLATE).withRawHtml("contextPath", contextPath).withValue("tokenValue", tokenValue).withRawHtml("csrf", csrfTokenHtmlInput.indent(8)).withValue("loginProcessingUrl", contextPath + this.loginProcessingUrl).render().getBytes(Charset.defaultCharset());
    }

    private static String csrfToken(CsrfToken token) {
        return HtmlTemplates.fromTemplate(CSRF_INPUT_TEMPLATE).withValue("name", token.getParameterName()).withValue("value", token.getToken()).render();
    }

    public void setRequestMatcher(ServerWebExchangeMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.matcher = requestMatcher;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be null or empty");
        this.loginProcessingUrl = loginProcessingUrl;
    }
}

