/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.init;

import liquibase.Scope;
import liquibase.command.core.init.InitProjectPromptingEnum;
import liquibase.ui.InputHandler;
import liquibase.ui.UIService;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCommandLineValueGetter<T> {
    public static final String NEW_PARAMETER_VALUES_SCOPE_KEY = "newParameterValues";
    private final Class<T> clazz;

    public AbstractCommandLineValueGetter(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final T prompt(InitProjectPromptingEnum parameter, Object currentValue) throws Exception {
        Object valueToPromptAsDefault;
        if (currentValue != null) {
            try {
                valueToPromptAsDefault = this.convert((String)currentValue);
            }
            catch (Exception e) {
                valueToPromptAsDefault = currentValue;
            }
        } else {
            valueToPromptAsDefault = parameter.defaultValue;
        }
        Object prompt = null;
        boolean valid = false;
        while (!valid && (prompt == null || prompt.equals(valueToPromptAsDefault))) {
            prompt = this.doPrompt(parameter, valueToPromptAsDefault, currentValue != null || parameter.defaultValue != null);
            try {
                valid = this.doValidate(parameter, prompt);
            }
            catch (IllegalArgumentException e) {
                UIService uiService = Scope.getCurrentScope().getUI();
                if (uiService.getAllowPrompt()) {
                    uiService.sendErrorMessage("Invalid value: '" + prompt + "': " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return (T)prompt;
    }

    private T doPrompt(final InitProjectPromptingEnum parameter, Object valueToPromptAsDefault, final boolean shouldAllowEmptyValues) {
        return (T)Scope.getCurrentScope().getUI().prompt(this.getMessage(parameter), valueToPromptAsDefault, new InputHandler<T>(){

            @Override
            public T parseInput(String input, Class<T> type) throws IllegalArgumentException {
                Object convert;
                try {
                    convert = AbstractCommandLineValueGetter.this.convert(input);
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        throw new IllegalArgumentException(String.format("Invalid value: '%s': %s", input, e.getMessage()), e);
                    }
                    throw new IllegalArgumentException(e);
                }
                try {
                    if (!AbstractCommandLineValueGetter.this.doValidate(parameter, convert)) {
                        throw new IllegalArgumentException("The supplied value is not valid.");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        throw new IllegalArgumentException(String.format("Invalid value: '%s': %s", input, e.getMessage()), e);
                    }
                    throw new IllegalArgumentException(String.format("Invalid value: '%s': The supplied value is not valid.", input), e);
                }
                return convert;
            }

            @Override
            public boolean shouldAllowEmptyInput() {
                return shouldAllowEmptyValues;
            }
        }, this.clazz);
    }

    private boolean doValidate(InitProjectPromptingEnum parameter, T convert) throws IllegalArgumentException {
        return this.validate(convert);
    }

    private String getMessage(InitProjectPromptingEnum parameter) {
        String msg = parameter.uiMessage;
        if (StringUtils.isNotEmpty((CharSequence)parameter.options)) {
            msg = msg + " (options: " + parameter.options + ")";
        }
        return msg;
    }

    public abstract boolean validate(T var1);

    public abstract T convert(String var1);

    public String describe() {
        return this.getClass().getSimpleName();
    }

    @Generated
    public Class<T> getClazz() {
        return this.clazz;
    }
}

