/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessor;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorVariant;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class DataframeAnalysisBase
implements JsonpSerializable {
    @Nullable
    private final Double alpha;
    private final String dependentVariable;
    @Nullable
    private final Double downsampleFactor;
    @Nullable
    private final Boolean earlyStoppingEnabled;
    @Nullable
    private final Double eta;
    @Nullable
    private final Double etaGrowthRatePerTree;
    @Nullable
    private final Double featureBagFraction;
    private final List<DataframeAnalysisFeatureProcessor> featureProcessors;
    @Nullable
    private final Double gamma;
    @Nullable
    private final Double lambda;
    @Nullable
    private final Integer maxOptimizationRoundsPerHyperparameter;
    @Nullable
    private final Integer maxTrees;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    @Nullable
    private final String predictionFieldName;
    @Nullable
    private final Double randomizeSeed;
    @Nullable
    private final Integer softTreeDepthLimit;
    @Nullable
    private final Double softTreeDepthTolerance;
    @Nullable
    private final String trainingPercent;

    protected DataframeAnalysisBase(AbstractBuilder<?> builder) {
        this.alpha = ((AbstractBuilder)builder).alpha;
        this.dependentVariable = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).dependentVariable, this, "dependentVariable");
        this.downsampleFactor = ((AbstractBuilder)builder).downsampleFactor;
        this.earlyStoppingEnabled = ((AbstractBuilder)builder).earlyStoppingEnabled;
        this.eta = ((AbstractBuilder)builder).eta;
        this.etaGrowthRatePerTree = ((AbstractBuilder)builder).etaGrowthRatePerTree;
        this.featureBagFraction = ((AbstractBuilder)builder).featureBagFraction;
        this.featureProcessors = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).featureProcessors);
        this.gamma = ((AbstractBuilder)builder).gamma;
        this.lambda = ((AbstractBuilder)builder).lambda;
        this.maxOptimizationRoundsPerHyperparameter = ((AbstractBuilder)builder).maxOptimizationRoundsPerHyperparameter;
        this.maxTrees = ((AbstractBuilder)builder).maxTrees;
        this.numTopFeatureImportanceValues = ((AbstractBuilder)builder).numTopFeatureImportanceValues;
        this.predictionFieldName = ((AbstractBuilder)builder).predictionFieldName;
        this.randomizeSeed = ((AbstractBuilder)builder).randomizeSeed;
        this.softTreeDepthLimit = ((AbstractBuilder)builder).softTreeDepthLimit;
        this.softTreeDepthTolerance = ((AbstractBuilder)builder).softTreeDepthTolerance;
        this.trainingPercent = ((AbstractBuilder)builder).trainingPercent;
    }

    @Nullable
    public final Double alpha() {
        return this.alpha;
    }

    public final String dependentVariable() {
        return this.dependentVariable;
    }

    @Nullable
    public final Double downsampleFactor() {
        return this.downsampleFactor;
    }

    @Nullable
    public final Boolean earlyStoppingEnabled() {
        return this.earlyStoppingEnabled;
    }

    @Nullable
    public final Double eta() {
        return this.eta;
    }

    @Nullable
    public final Double etaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    @Nullable
    public final Double featureBagFraction() {
        return this.featureBagFraction;
    }

    public final List<DataframeAnalysisFeatureProcessor> featureProcessors() {
        return this.featureProcessors;
    }

    @Nullable
    public final Double gamma() {
        return this.gamma;
    }

    @Nullable
    public final Double lambda() {
        return this.lambda;
    }

    @Nullable
    public final Integer maxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    @Nullable
    public final Integer maxTrees() {
        return this.maxTrees;
    }

    @Nullable
    public final Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Nullable
    public final String predictionFieldName() {
        return this.predictionFieldName;
    }

    @Nullable
    public final Double randomizeSeed() {
        return this.randomizeSeed;
    }

    @Nullable
    public final Integer softTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    @Nullable
    public final Double softTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    @Nullable
    public final String trainingPercent() {
        return this.trainingPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write(this.alpha.doubleValue());
        }
        generator.writeKey("dependent_variable");
        generator.write(this.dependentVariable);
        if (this.downsampleFactor != null) {
            generator.writeKey("downsample_factor");
            generator.write(this.downsampleFactor.doubleValue());
        }
        if (this.earlyStoppingEnabled != null) {
            generator.writeKey("early_stopping_enabled");
            generator.write(this.earlyStoppingEnabled.booleanValue());
        }
        if (this.eta != null) {
            generator.writeKey("eta");
            generator.write(this.eta.doubleValue());
        }
        if (this.etaGrowthRatePerTree != null) {
            generator.writeKey("eta_growth_rate_per_tree");
            generator.write(this.etaGrowthRatePerTree.doubleValue());
        }
        if (this.featureBagFraction != null) {
            generator.writeKey("feature_bag_fraction");
            generator.write(this.featureBagFraction.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.featureProcessors)) {
            generator.writeKey("feature_processors");
            generator.writeStartArray();
            for (DataframeAnalysisFeatureProcessor item0 : this.featureProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.gamma != null) {
            generator.writeKey("gamma");
            generator.write(this.gamma.doubleValue());
        }
        if (this.lambda != null) {
            generator.writeKey("lambda");
            generator.write(this.lambda.doubleValue());
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            generator.writeKey("max_optimization_rounds_per_hyperparameter");
            generator.write(this.maxOptimizationRoundsPerHyperparameter.intValue());
        }
        if (this.maxTrees != null) {
            generator.writeKey("max_trees");
            generator.write(this.maxTrees.intValue());
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
        if (this.predictionFieldName != null) {
            generator.writeKey("prediction_field_name");
            generator.write(this.predictionFieldName);
        }
        if (this.randomizeSeed != null) {
            generator.writeKey("randomize_seed");
            generator.write(this.randomizeSeed.doubleValue());
        }
        if (this.softTreeDepthLimit != null) {
            generator.writeKey("soft_tree_depth_limit");
            generator.write(this.softTreeDepthLimit.intValue());
        }
        if (this.softTreeDepthTolerance != null) {
            generator.writeKey("soft_tree_depth_tolerance");
            generator.write(this.softTreeDepthTolerance.doubleValue());
        }
        if (this.trainingPercent != null) {
            generator.writeKey("training_percent");
            generator.write(this.trainingPercent);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupDataframeAnalysisBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::alpha, JsonpDeserializer.doubleDeserializer(), "alpha");
        op.add(AbstractBuilder::dependentVariable, JsonpDeserializer.stringDeserializer(), "dependent_variable");
        op.add(AbstractBuilder::downsampleFactor, JsonpDeserializer.doubleDeserializer(), "downsample_factor");
        op.add(AbstractBuilder::earlyStoppingEnabled, JsonpDeserializer.booleanDeserializer(), "early_stopping_enabled");
        op.add(AbstractBuilder::eta, JsonpDeserializer.doubleDeserializer(), "eta");
        op.add(AbstractBuilder::etaGrowthRatePerTree, JsonpDeserializer.doubleDeserializer(), "eta_growth_rate_per_tree");
        op.add(AbstractBuilder::featureBagFraction, JsonpDeserializer.doubleDeserializer(), "feature_bag_fraction");
        op.add(AbstractBuilder::featureProcessors, JsonpDeserializer.arrayDeserializer(DataframeAnalysisFeatureProcessor._DESERIALIZER), "feature_processors");
        op.add(AbstractBuilder::gamma, JsonpDeserializer.doubleDeserializer(), "gamma");
        op.add(AbstractBuilder::lambda, JsonpDeserializer.doubleDeserializer(), "lambda");
        op.add(AbstractBuilder::maxOptimizationRoundsPerHyperparameter, JsonpDeserializer.integerDeserializer(), "max_optimization_rounds_per_hyperparameter");
        op.add(AbstractBuilder::maxTrees, JsonpDeserializer.integerDeserializer(), "max_trees", "maximum_number_trees");
        op.add(AbstractBuilder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values");
        op.add(AbstractBuilder::predictionFieldName, JsonpDeserializer.stringDeserializer(), "prediction_field_name");
        op.add(AbstractBuilder::randomizeSeed, JsonpDeserializer.doubleDeserializer(), "randomize_seed");
        op.add(AbstractBuilder::softTreeDepthLimit, JsonpDeserializer.integerDeserializer(), "soft_tree_depth_limit");
        op.add(AbstractBuilder::softTreeDepthTolerance, JsonpDeserializer.doubleDeserializer(), "soft_tree_depth_tolerance");
        op.add(AbstractBuilder::trainingPercent, JsonpDeserializer.stringDeserializer(), "training_percent");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Double alpha;
        private String dependentVariable;
        @Nullable
        private Double downsampleFactor;
        @Nullable
        private Boolean earlyStoppingEnabled;
        @Nullable
        private Double eta;
        @Nullable
        private Double etaGrowthRatePerTree;
        @Nullable
        private Double featureBagFraction;
        @Nullable
        private List<DataframeAnalysisFeatureProcessor> featureProcessors;
        @Nullable
        private Double gamma;
        @Nullable
        private Double lambda;
        @Nullable
        private Integer maxOptimizationRoundsPerHyperparameter;
        @Nullable
        private Integer maxTrees;
        @Nullable
        private Integer numTopFeatureImportanceValues;
        @Nullable
        private String predictionFieldName;
        @Nullable
        private Double randomizeSeed;
        @Nullable
        private Integer softTreeDepthLimit;
        @Nullable
        private Double softTreeDepthTolerance;
        @Nullable
        private String trainingPercent;

        public final BuilderT alpha(@Nullable Double value) {
            this.alpha = value;
            return (BuilderT)this.self();
        }

        public final BuilderT dependentVariable(String value) {
            this.dependentVariable = value;
            return (BuilderT)this.self();
        }

        public final BuilderT downsampleFactor(@Nullable Double value) {
            this.downsampleFactor = value;
            return (BuilderT)this.self();
        }

        public final BuilderT earlyStoppingEnabled(@Nullable Boolean value) {
            this.earlyStoppingEnabled = value;
            return (BuilderT)this.self();
        }

        public final BuilderT eta(@Nullable Double value) {
            this.eta = value;
            return (BuilderT)this.self();
        }

        public final BuilderT etaGrowthRatePerTree(@Nullable Double value) {
            this.etaGrowthRatePerTree = value;
            return (BuilderT)this.self();
        }

        public final BuilderT featureBagFraction(@Nullable Double value) {
            this.featureBagFraction = value;
            return (BuilderT)this.self();
        }

        public final BuilderT featureProcessors(List<DataframeAnalysisFeatureProcessor> list) {
            this.featureProcessors = AbstractBuilder._listAddAll(this.featureProcessors, list);
            return (BuilderT)this.self();
        }

        public final BuilderT featureProcessors(DataframeAnalysisFeatureProcessor value, DataframeAnalysisFeatureProcessor ... values) {
            this.featureProcessors = AbstractBuilder._listAdd(this.featureProcessors, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT featureProcessors(DataframeAnalysisFeatureProcessorVariant value, DataframeAnalysisFeatureProcessorVariant ... values) {
            this.featureProcessors = AbstractBuilder._listAdd(this.featureProcessors, value._toDataframeAnalysisFeatureProcessor(), new DataframeAnalysisFeatureProcessor[0]);
            for (DataframeAnalysisFeatureProcessorVariant v : values) {
                AbstractBuilder._listAdd(this.featureProcessors, v._toDataframeAnalysisFeatureProcessor(), new DataframeAnalysisFeatureProcessor[0]);
            }
            return (BuilderT)this.self();
        }

        public final BuilderT featureProcessors(Function<DataframeAnalysisFeatureProcessor.Builder, ObjectBuilder<DataframeAnalysisFeatureProcessor>> fn) {
            return this.featureProcessors(fn.apply(new DataframeAnalysisFeatureProcessor.Builder()).build(), new DataframeAnalysisFeatureProcessor[0]);
        }

        public final BuilderT gamma(@Nullable Double value) {
            this.gamma = value;
            return (BuilderT)this.self();
        }

        public final BuilderT lambda(@Nullable Double value) {
            this.lambda = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxOptimizationRoundsPerHyperparameter(@Nullable Integer value) {
            this.maxOptimizationRoundsPerHyperparameter = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxTrees(@Nullable Integer value) {
            this.maxTrees = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return (BuilderT)this.self();
        }

        public final BuilderT predictionFieldName(@Nullable String value) {
            this.predictionFieldName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT randomizeSeed(@Nullable Double value) {
            this.randomizeSeed = value;
            return (BuilderT)this.self();
        }

        public final BuilderT softTreeDepthLimit(@Nullable Integer value) {
            this.softTreeDepthLimit = value;
            return (BuilderT)this.self();
        }

        public final BuilderT softTreeDepthTolerance(@Nullable Double value) {
            this.softTreeDepthTolerance = value;
            return (BuilderT)this.self();
        }

        public final BuilderT trainingPercent(@Nullable String value) {
            this.trainingPercent = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

