/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.runtime;

import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.gatein.management.api.ExternalContext;

public class ExternalContextImpl
implements ExternalContext {
    public String getRemoteUser() {
        Identity identity = ExternalContextImpl.getIdentity();
        if (identity != null) {
            String user = identity.getUserId();
            if (IdentityConstants.ANONIM.equals(user)) {
                return null;
            }
            return user;
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        if (role == null) {
            return false;
        }
        Identity identity = ExternalContextImpl.getIdentity();
        if (identity != null) {
            for (String r : identity.getRoles()) {
                if (!role.equals(r)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static Identity getIdentity() {
        ConversationState conversation = ConversationState.getCurrent();
        if (conversation == null) {
            return null;
        }
        return conversation.getIdentity();
    }
}

