/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch.text_structure.FindFieldStructureRequest;
import co.elastic.clients.elasticsearch.text_structure.FindFieldStructureResponse;
import co.elastic.clients.elasticsearch.text_structure.FindMessageStructureRequest;
import co.elastic.clients.elasticsearch.text_structure.FindMessageStructureResponse;
import co.elastic.clients.elasticsearch.text_structure.TestGrokPatternRequest;
import co.elastic.clients.elasticsearch.text_structure.TestGrokPatternResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchTextStructureAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchTextStructureAsyncClient> {
    public ElasticsearchTextStructureAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchTextStructureAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchTextStructureAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchTextStructureAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<FindFieldStructureResponse> findFieldStructure(FindFieldStructureRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)FindFieldStructureRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<FindFieldStructureResponse> findFieldStructure(Function<FindFieldStructureRequest.Builder, ObjectBuilder<FindFieldStructureRequest>> fn) {
        return this.findFieldStructure(fn.apply(new FindFieldStructureRequest.Builder()).build());
    }

    public CompletableFuture<FindMessageStructureResponse> findMessageStructure(FindMessageStructureRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)FindMessageStructureRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<FindMessageStructureResponse> findMessageStructure(Function<FindMessageStructureRequest.Builder, ObjectBuilder<FindMessageStructureRequest>> fn) {
        return this.findMessageStructure(fn.apply(new FindMessageStructureRequest.Builder()).build());
    }

    public CompletableFuture<TestGrokPatternResponse> testGrokPattern(TestGrokPatternRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)TestGrokPatternRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<TestGrokPatternResponse> testGrokPattern(Function<TestGrokPatternRequest.Builder, ObjectBuilder<TestGrokPatternRequest>> fn) {
        return this.testGrokPattern(fn.apply(new TestGrokPatternRequest.Builder()).build());
    }
}

