/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.FilterDefinition;
import org.exoplatform.web.filter.FilterDefinitionPlugin;

public class ExtensibleFilter {
    private static final Log LOG = ExoLogger.getLogger(ExtensibleFilter.class);
    private volatile List<FilterDefinition> filters = Collections.unmodifiableList(new ArrayList());

    public void addFilterDefinitions(FilterDefinitionPlugin plugin) {
        this.addFilterDefinitions(plugin.getFilterDefinitions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFilterDefinitions(List<FilterDefinition> pluginFilters) {
        if (pluginFilters == null || pluginFilters.isEmpty()) {
            return;
        }
        ExtensibleFilter extensibleFilter = this;
        synchronized (extensibleFilter) {
            ArrayList<FilterDefinition> result = new ArrayList<FilterDefinition>(this.filters);
            result.addAll(pluginFilters);
            this.filters = Collections.unmodifiableList(result);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, String path) throws IOException, ServletException {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(chain, this.filters, path);
        efChain.doFilter(request, response);
    }

    private static class ExtensibleFilterChain
    implements FilterChain {
        private final FilterChain parentChain;
        private final Iterator<FilterDefinition> filters;
        private final String path;

        private ExtensibleFilterChain(FilterChain parentChain, List<FilterDefinition> filters, String path_) {
            this.parentChain = parentChain;
            this.filters = filters.iterator();
            this.path = path_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            PortalContainer exoContainer;
            block15: {
                block13: {
                    block14: {
                        exoContainer = PortalContainer.getInstanceIfPresent();
                        if (exoContainer != null) {
                            ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                            RequestLifeCycle.begin((ExoContainer)exoContainer);
                        }
                        try {
                            while (this.filters.hasNext()) {
                                FilterDefinition filterDef = this.filters.next();
                                if (!filterDef.getMapping().match(this.path)) continue;
                                filterDef.getFilter().doFilter(request, response, this);
                                if (exoContainer == null) break block13;
                                break block14;
                            }
                            break block15;
                        }
                        catch (Throwable throwable) {
                            if (exoContainer != null) {
                                RequestLifeCycle.end();
                                List transactionalServices = exoContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
                                for (ComponentRequestLifecycle service : transactionalServices) {
                                    if (!service.isStarted((ExoContainer)exoContainer)) continue;
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("The service {} didn't called endRequest. Commit transaction anyway.", new Object[]{service.getClass().getName()});
                                    }
                                    service.endRequest((ExoContainer)exoContainer);
                                    if (!service.isStarted((ExoContainer)exoContainer)) continue;
                                    LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName()});
                                }
                            }
                            throw throwable;
                        }
                    }
                    RequestLifeCycle.end();
                    List transactionalServices = exoContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
                    for (ComponentRequestLifecycle service : transactionalServices) {
                        if (!service.isStarted((ExoContainer)exoContainer)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("The service {} didn't called endRequest. Commit transaction anyway.", new Object[]{service.getClass().getName()});
                        }
                        service.endRequest((ExoContainer)exoContainer);
                        if (!service.isStarted((ExoContainer)exoContainer)) continue;
                        LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName()});
                    }
                }
                return;
            }
            if (exoContainer != null) {
                RequestLifeCycle.end();
                List transactionalServices = exoContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
                for (ComponentRequestLifecycle service : transactionalServices) {
                    if (!service.isStarted((ExoContainer)exoContainer)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The service {} didn't called endRequest. Commit transaction anyway.", new Object[]{service.getClass().getName()});
                    }
                    service.endRequest((ExoContainer)exoContainer);
                    if (!service.isStarted((ExoContainer)exoContainer)) continue;
                    LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName()});
                }
            }
            this.parentChain.doFilter(request, response);
        }
    }
}

