/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.plugin.SidebarPlugin;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLayoutSidebarPlugin
implements SidebarPlugin {
    public static final String SITE_NAME_PROP_NAME = "siteName";
    public static final String SITE_ID_PROP_NAME = "siteId";
    public static final String SITE_TYPE_PROP_NAME = "siteType";
    public static final String SITE_EXPAND_PAGES_PROP_NAME = "expandPages";
    public static final String NODE_ID_PROP_NAME = "navigationNodeId";
    public static final String SITE_DISPLAY_NAME_PROP_NAME = "siteDisplayName";
    public static final String SITE_ICON_PROP_NAME = "siteIcon";
    public static final String SITE_TRANSLATION_OBJECT_TYPE = "site";
    public static final String SITE_TRANSLATION_LABEL_FIELD_NAME = "label";
    @Autowired
    protected NavigationService navigationService;
    @Autowired
    protected LayoutService layoutService;
    @Autowired
    protected TranslationService translationService;
    @Autowired
    protected DescriptionService descriptionService;
    @Autowired
    protected ResourceBundleManager resourceBundleManager;
    @Autowired
    protected LocaleConfigService localeConfigService;
    @Autowired
    protected OrganizationService organizationService;
    @Autowired
    protected UserACL userAcl;
    @Autowired
    private WebAppController webController;

    protected SidebarItem resolvePageItemProperties(SidebarItem item, Locale locale) {
        String nodeId = (String)item.getProperties().get(NODE_ID_PROP_NAME);
        NodeData node = this.navigationService.getNodeById(Long.valueOf(Long.parseLong(nodeId)));
        SiteKey siteKey = node.getSiteKey();
        long siteId = this.getSiteId(siteKey);
        item.setName(this.getNodeLabel(Long.parseLong(nodeId), locale));
        if (item.getIcon() == null) {
            item.setIcon(node.getState().getIcon());
        }
        item.setProperties(new HashMap(item.getProperties()));
        item.getProperties().put(SITE_ID_PROP_NAME, String.valueOf(siteId));
        item.getProperties().put(SITE_TYPE_PROP_NAME, siteKey.getTypeName());
        item.getProperties().put(SITE_NAME_PROP_NAME, siteKey.getName());
        item.getProperties().put(SITE_ICON_PROP_NAME, this.getSiteIcon(siteKey));
        item.getProperties().put(SITE_DISPLAY_NAME_PROP_NAME, this.getSiteLabel(siteKey, locale));
        if (node.getState().getPageRef() != null) {
            Page page = this.layoutService.getPage(node.getState().getPageRef());
            if (PageType.LINK.name().equals(page.getType())) {
                item.setUrl(page.getLink());
                item.setTarget(node.getState().getTarget());
            } else {
                item.setUrl(this.getNodeUri(node));
                item.setDefaultPath(true);
            }
        }
        return item;
    }

    protected String getNodeLabel(long nodeId, Locale locale) {
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        Map nodeLabels = this.descriptionService.getDescriptions(String.valueOf(nodeId));
        if (MapUtils.isEmpty((Map)nodeLabels)) {
            return this.getLabelOrDefault(nodeData.getSiteKey(), nodeData.getState().getLabel(), locale, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{nodeData.getState().getLabel(), nodeData.getName()}));
        }
        if (nodeLabels.containsKey(locale)) {
            return ((State)nodeLabels.get(locale)).getName();
        }
        if (nodeLabels.containsKey(this.localeConfigService.getDefaultLocaleConfig().getLocale())) {
            return ((State)nodeLabels.get(this.localeConfigService.getDefaultLocaleConfig().getLocale())).getName();
        }
        if (nodeLabels.containsKey(ResourceBundleService.DEFAULT_CROWDIN_LOCALE)) {
            return ((State)nodeLabels.get(ResourceBundleService.DEFAULT_CROWDIN_LOCALE)).getName();
        }
        return ((State)nodeLabels.values().iterator().next()).getName();
    }

    protected String getSiteIcon(SiteKey siteKey) {
        NodeContext rootNode = this.navigationService.loadNode(siteKey);
        if (rootNode != null && rootNode.getSize() > 0) {
            Collection nodes = rootNode.getNodes();
            return nodes.stream().map(node -> {
                NodeData data = node.getData();
                NodeState state = data.getState();
                if (this.isVisibilityEligible(state) && state.getPageRef() != null && StringUtils.isNotBlank((CharSequence)state.getIcon())) {
                    return state.getIcon();
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    protected String getSiteLabel(SiteKey siteKey, Locale locale) {
        Group siteGroup;
        long siteId = this.getSiteId(siteKey);
        String label = this.translationService.getTranslationLabelOrDefault(SITE_TRANSLATION_OBJECT_TYPE, siteId, SITE_TRANSLATION_LABEL_FIELD_NAME, locale);
        if (StringUtils.isNotBlank((CharSequence)label)) {
            return label;
        }
        PortalConfig site = this.layoutService.getPortalConfig(siteId);
        label = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{site.getLabel(), site.getName(), siteKey.getName()});
        if (siteKey.getType() == SiteType.PORTAL) {
            return this.getLabelOrDefault(siteKey, label, locale, siteKey.getName());
        }
        if (siteKey.getType() == SiteType.GROUP && (siteGroup = this.organizationService.getGroupHandler().findGroupById(siteKey.getName())) != null) {
            return siteGroup.getLabel();
        }
        return label;
    }

    protected boolean isEligiblePage(long nodeId, String username) {
        NodeData node = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (node == null || node.getSiteKey() == null || node.getState() == null) {
            return false;
        }
        PortalConfig site = this.layoutService.getPortalConfig(node.getSiteKey());
        if (!this.userAcl.hasAccessPermission(site, this.userAcl.getUserIdentity(username))) {
            return false;
        }
        if (node.getState() == null || !this.isVisibilityEligible(node.getState())) {
            return false;
        }
        if (node.getState().getPageRef() == null) {
            return node.iterator(false).hasNext();
        }
        Page page = this.layoutService.getPage(node.getState().getPageRef());
        if (page == null) {
            return node.iterator(false).hasNext();
        }
        return this.userAcl.hasAccessPermission(page, this.userAcl.getUserIdentity(username));
    }

    protected boolean isVisibilityEligible(NodeState state) {
        if (state.getVisibility() == Visibility.DISPLAYED) {
            return true;
        }
        if (state.getVisibility() == Visibility.TEMPORAL) {
            return !(state.getEndPublicationTime() != 0L && state.getEndPublicationTime() >= System.currentTimeMillis() || state.getStartPublicationTime() != 0L && state.getStartPublicationTime() <= System.currentTimeMillis());
        }
        return false;
    }

    private String getNodeUri(NodeData node) {
        SiteKey siteKey = node.getSiteKey();
        StringBuilder uriBuilder = new StringBuilder();
        this.buildUri(node, uriBuilder);
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "portal");
        params.put(PortalRequestHandler.REQUEST_SITE_NAME, siteKey.getName());
        params.put(PortalRequestHandler.REQUEST_SITE_TYPE, siteKey.getTypeName());
        params.put(PortalRequestHandler.REQUEST_PATH, uriBuilder.toString().replaceFirst("/", ""));
        params.put(PortalRequestHandler.LANG, Locale.ENGLISH.toLanguageTag());
        return "/portal" + this.webController.getRouter().render(params).replace("/en", "").replace("?lang=en", "").replace("&lang=en", "");
    }

    private void buildUri(NodeData node, StringBuilder uriBuilder) {
        if (StringUtils.isNotBlank((CharSequence)node.getName()) && !StringUtils.equals((CharSequence)node.getName(), (CharSequence)"default")) {
            uriBuilder.insert(0, node.getName());
            if (!uriBuilder.isEmpty()) {
                uriBuilder.insert(0, "/");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)node.getParentId())) {
            NodeData parentNode = this.navigationService.getNodeById(Long.valueOf(Long.parseLong(node.getParentId())));
            this.buildUri(parentNode, uriBuilder);
        }
    }

    private String getLabelOrDefault(SiteKey siteKey, String label, Locale locale, String defaultLabel) {
        if (ExpressionUtil.isResourceBindingExpression((String)label)) {
            return Stream.of(locale, ResourceBundleService.DEFAULT_CROWDIN_LOCALE).map(l -> this.getBundle(siteKey.getTypeName(), siteKey.getName(), locale)).filter(Objects::nonNull).map(b -> ExpressionUtil.getExpressionValue((ResourceBundle)b, (String)label)).filter(StringUtils::isNotBlank).findFirst().orElse(defaultLabel);
        }
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{label, defaultLabel});
    }

    private long getSiteId(SiteKey siteKey) {
        PortalConfig site = this.layoutService.getPortalConfig(siteKey);
        return Long.parseLong(site.getStorageId().split("_")[1]);
    }

    private ResourceBundle getBundle(String siteType, String siteName, Locale locale) {
        return this.resourceBundleManager.getNavigationResourceBundle(LocaleContextInfo.getLocaleAsString((Locale)locale), siteType, siteName);
    }
}

