/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LoggingAction
implements JsonpSerializable {
    @Nullable
    private final String level;
    private final String text;
    @Nullable
    private final String category;
    public static final JsonpDeserializer<LoggingAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LoggingAction::setupLoggingActionDeserializer);

    private LoggingAction(Builder builder) {
        this.level = builder.level;
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.category = builder.category;
    }

    public static LoggingAction of(Function<Builder, ObjectBuilder<LoggingAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String level() {
        return this.level;
    }

    public final String text() {
        return this.text;
    }

    @Nullable
    public final String category() {
        return this.category;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.level != null) {
            generator.writeKey("level");
            generator.write(this.level);
        }
        generator.writeKey("text");
        generator.write(this.text);
        if (this.category != null) {
            generator.writeKey("category");
            generator.write(this.category);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLoggingActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::level, JsonpDeserializer.stringDeserializer(), "level");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::category, JsonpDeserializer.stringDeserializer(), "category");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LoggingAction> {
        @Nullable
        private String level;
        private String text;
        @Nullable
        private String category;

        public final Builder level(@Nullable String value) {
            this.level = value;
            return this;
        }

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder category(@Nullable String value) {
            this.category = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LoggingAction build() {
            this._checkSingleUse();
            return new LoggingAction(this);
        }
    }
}

