/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.metamodel.mapping.ValuedModelPart;

public interface EntityIdentifierMapping
extends ValuedModelPart {
    public static final String ID_ROLE_NAME = "{id}";
    public static final String LEGACY_ID_NAME = "id";

    public static boolean matchesRoleName(String name) {
        return LEGACY_ID_NAME.equalsIgnoreCase(name) || ID_ROLE_NAME.equals(name);
    }

    @Override
    default public String getPartName() {
        return ID_ROLE_NAME;
    }

    public Nature getNature();

    public String getAttributeName();

    public IdentifierValue getUnsavedStrategy();

    public Object instantiate();

    public Object getIdentifier(Object var1);

    default public Object getIdentifier(Object entity, MergeContext mergeContext) {
        return this.getIdentifier(entity);
    }

    default public Object getIdentifierIfNotUnsaved(Object entity, SharedSessionContractImplementor session) {
        if (entity == null) {
            return null;
        }
        if (session == null) {
            return this.getIdentifier(entity);
        }
        Object id = session.getContextEntityIdentifier(entity);
        if (id == null) {
            String entityName = this.findContainingEntityMapping().getEntityName();
            if (ForeignKeys.isTransient(entityName, entity, Boolean.FALSE, session)) {
                throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (entityName == null ? session.guessEntityName(entity) : entityName));
            }
            id = this.getIdentifier(entity);
        }
        return id;
    }

    public void setIdentifier(Object var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    default public boolean isEntityIdentifierMapping() {
        return true;
    }

    public static enum Nature {
        SIMPLE,
        COMPOSITE,
        VIRTUAL;

    }
}

