/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.plugin.analytics.BasePwaStatisticCollector;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class PwaNotificationListener
extends BasePwaStatisticCollector
implements ListenerBase<String, Map<String, Object>> {
    private static final Log LOG = ExoLogger.getLogger(PwaNotificationListener.class);
    private static final List<String> EVENT_NAMES = Arrays.asList("pwa.notificationSent", "pwa.notificationResponseError", "pwa.notificationSendingError", "pwa.outdatedSubscription");
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(e -> this.listenerService.addListener(e, (ListenerBase)this));
    }

    public void onEvent(Event<String, Map<String, Object>> event) throws Exception {
        String eventName = event.getEventName();
        String username = (String)event.getSource();
        Map params = (Map)event.getData();
        UserPushSubscription subscription = (UserPushSubscription)params.get("subscription");
        StatisticData statisticData = this.addSubscriptionDetails(subscription, username);
        statisticData.setSubModule("pwaNotification");
        statisticData.setOperation(this.getOperation(eventName));
        statisticData.setStatus("pwa.notificationSent".equals(eventName) ? StatisticData.StatisticStatus.OK : StatisticData.StatisticStatus.KO);
        statisticData.setDuration(((Long)params.get("duration")).longValue());
        HttpResponse httpResponse = (HttpResponse)params.get("httpResponse");
        String errorMessage = (String)params.get("error");
        this.addErrorMessage(eventName, statisticData, httpResponse, errorMessage);
        this.addHttpResponseCode(statisticData, httpResponse);
        this.addNotificationAction(statisticData, (String)params.get("action"));
        this.addNotificationId(statisticData, (Long)params.get("notificationId"));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private void addHttpResponseCode(StatisticData statisticData, HttpResponse httpResponse) {
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            statisticData.addParameter("pwaHttpResponseCode", (Object)httpResponse.getStatusLine().getStatusCode());
        }
    }

    private void addNotificationId(StatisticData statisticData, Long notificationId) {
        if (notificationId != null) {
            statisticData.addParameter("pwaNotificationId", (Object)notificationId);
        }
    }

    private void addNotificationAction(StatisticData statisticData, String action) {
        if (StringUtils.isNotBlank((CharSequence)action)) {
            statisticData.addParameter("pwaAction", (Object)action);
        }
    }

    private void addErrorMessage(String eventName, StatisticData statisticData, HttpResponse httpResponse, String errorMessage) {
        if (httpResponse != null && StringUtils.equals((CharSequence)"pwa.notificationResponseError", (CharSequence)eventName)) {
            errorMessage = this.getErrorMessage(httpResponse);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            statisticData.addParameter("pwaErrorMessage", (Object)errorMessage);
        }
    }

    private String getErrorMessage(HttpResponse httpResponse) {
        if (httpResponse.getEntity() != null) {
            String string;
            block9: {
                InputStream inputStream = httpResponse.getEntity().getContent();
                try {
                    string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error while retrieving HTTP Response content", (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return string;
        }
        return null;
    }

    private String getOperation(String eventName) {
        return switch (eventName) {
            case "pwa.notificationSent" -> "pwaNotificationSent";
            case "pwa.notificationResponseError" -> "pwaNotificationPushServerError";
            case "pwa.notificationSendingError" -> "pwaNotificationInternalError";
            case "pwa.outdatedSubscription" -> "pwaNotificationSubscriptionOutdated";
            default -> throw new IllegalArgumentException("Unexpected event name value: " + eventName);
        };
    }
}

