/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import oracle.jdbc.OracleConnection;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.mapping.UserDefinedArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayJdbcType
extends ArrayJdbcType
implements SqlTypedJdbcType {
    private final String typeName;
    private final String upperTypeName;

    public OracleArrayJdbcType(JdbcType elementJdbcType, String typeName) {
        super(elementJdbcType);
        this.typeName = typeName;
        this.upperTypeName = typeName == null ? null : typeName.toUpperCase(Locale.ROOT);
    }

    @Override
    public String getSqlTypeName() {
        return this.typeName;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        final ValueBinder elementBinder = this.getElementJdbcType().getBinder(((BasicPluralJavaType)((Object)javaTypeDescriptor)).getElementJavaType());
        return new BasicBinder<X>(javaTypeDescriptor, this){

            private String typeName(WrapperOptions options) {
                return OracleArrayJdbcType.this.upperTypeName == null ? OracleArrayJdbcType.getTypeName(options, (BasicPluralJavaType)((Object)this.getJavaType()), (ArrayJdbcType)this.getJdbcType()).toUpperCase(Locale.ROOT) : OracleArrayJdbcType.this.upperTypeName;
            }

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 2003, this.typeName(options));
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 2003, this.typeName(options));
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, (Array)this.getBindValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Object arr = this.getBindValue(value, options);
                try {
                    st.setObject(name, arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            @Override
            public Array getBindValue(X value, WrapperOptions options) throws SQLException {
                Object[] objects = ((OracleArrayJdbcType)this.getJdbcType()).getArray(this, elementBinder, value, options);
                String arrayTypeName = this.typeName(options);
                OracleConnection oracleConnection = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().unwrap(OracleConnection.class);
                try {
                    return oracleConnection.createOracleArray(arrayTypeName, (Object)objects);
                }
                catch (Exception e) {
                    throw new HibernateException("Couldn't create a java.sql.Array", e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, statement.getArray(name), options);
            }
        };
    }

    static String getTypeName(WrapperOptions options, BasicPluralJavaType<?> containerJavaType, ArrayJdbcType arrayJdbcType) {
        Dialect dialect = options.getSessionFactory().getJdbcServices().getDialect();
        return OracleArrayJdbcType.getTypeName(containerJavaType.getElementJavaType(), arrayJdbcType.getElementJdbcType(), dialect);
    }

    static String getTypeName(BasicType<?> elementType, Dialect dialect) {
        BasicValueConverter<?, ?> converter = elementType.getValueConverter();
        if (converter != null) {
            String simpleName = converter instanceof JpaAttributeConverter ? ((JpaAttributeConverter)converter).getConverterJavaType().getJavaTypeClass().getSimpleName() : converter.getClass().getSimpleName();
            return dialect.getArrayTypeName(simpleName, null, null);
        }
        return OracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), elementType.getJdbcType(), dialect);
    }

    static String getTypeName(JavaType<?> elementJavaType, JdbcType elementJdbcType, Dialect dialect) {
        Class<?> preferredJavaTypeClass;
        Object simpleName = elementJavaType.getJavaTypeClass().isArray() ? dialect.getArrayTypeName(elementJavaType.getJavaTypeClass().getComponentType().getSimpleName(), null, null) : (elementJdbcType instanceof StructJdbcType ? ((StructJdbcType)elementJdbcType).getStructTypeName() : ((preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(null)) == elementJavaType.getJavaTypeClass() ? elementJavaType.getJavaTypeClass().getSimpleName() : (preferredJavaTypeClass.isArray() ? elementJavaType.getJavaTypeClass().getSimpleName() + dialect.getArrayTypeName(preferredJavaTypeClass.getComponentType().getSimpleName(), null, null) : elementJavaType.getJavaTypeClass().getSimpleName() + preferredJavaTypeClass.getSimpleName())));
        return dialect.getArrayTypeName((String)simpleName, null, null);
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, Size columnSize, Database database, TypeConfiguration typeConfiguration) {
        JdbcType elementJdbcType = this.getElementJdbcType();
        if (elementJdbcType instanceof StructJdbcType) {
            return;
        }
        Dialect dialect = database.getDialect();
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        JavaType elementJavaType = pluralJavaType.getElementJavaType();
        String arrayTypeName = this.typeName == null ? OracleArrayJdbcType.getTypeName(elementJavaType, elementJdbcType, dialect) : this.typeName;
        String elementType = typeConfiguration.getDdlTypeRegistry().getTypeName(elementJdbcType.getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(elementJdbcType, elementJavaType, columnSize.getPrecision(), columnSize.getScale(), columnSize.getLength()), new BasicTypeImpl(elementJavaType, elementJdbcType));
        UserDefinedArrayType userDefinedArrayType = database.getDefaultNamespace().createUserDefinedArrayType(Identifier.toIdentifier(arrayTypeName), name -> new UserDefinedArrayType("orm", database.getDefaultNamespace(), (Identifier)name));
        userDefinedArrayType.setArraySqlTypeCode(this.getDdlTypeCode());
        userDefinedArrayType.setElementTypeName(elementType);
        userDefinedArrayType.setElementSqlTypeCode(elementJdbcType.getDefaultSqlTypeCode());
        userDefinedArrayType.setArrayLength(columnSize.getArrayLength() == null ? 127 : columnSize.getArrayLength());
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, String name) throws SQLException {
        callableStatement.registerOutParameter(name, 2003, this.upperTypeName);
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        callableStatement.registerOutParameter(index, 2003, this.upperTypeName);
    }

    @Override
    public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        return this.getElementJdbcType().getExtraCreateTableInfo(((BasicPluralJavaType)((Object)javaType)).getElementJavaType(), columnName, tableName, database);
    }

    @Override
    public String getFriendlyName() {
        return this.typeName;
    }

    @Override
    public String toString() {
        return "OracleArrayTypeDescriptor(" + this.typeName + ")";
    }
}

