/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.ExecutionListenersTransactionManagerCustomizer;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizer;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.TransactionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionExecutionListener;

@ConditionalOnClass(value={PlatformTransactionManager.class})
@AutoConfiguration(before={TransactionAutoConfiguration.class})
@EnableConfigurationProperties(value={TransactionProperties.class})
public class TransactionManagerCustomizationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    TransactionManagerCustomizers platformTransactionManagerCustomizers(ObjectProvider<TransactionManagerCustomizer<?>> customizers) {
        return TransactionManagerCustomizers.of(customizers.orderedStream().toList());
    }

    @Bean
    ExecutionListenersTransactionManagerCustomizer transactionExecutionListeners(ObjectProvider<TransactionExecutionListener> listeners) {
        return new ExecutionListenersTransactionManagerCustomizer(listeners.orderedStream().toList());
    }
}

