/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.alps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.mediatype.alps.Descriptor;
import org.springframework.hateoas.mediatype.alps.Doc;
import org.springframework.hateoas.mediatype.alps.Ext;

@JsonPropertyOrder(value={"version", "doc", "descriptor"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Alps {
    private final String version;
    private final Doc doc;
    private final List<Descriptor> descriptor;

    @JsonCreator
    private Alps(@JsonProperty(value="version") String version, @JsonProperty(value="doc") Doc doc, @JsonProperty(value="descriptor") List<Descriptor> descriptor) {
        this.version = "1.0";
        this.doc = doc;
        this.descriptor = descriptor;
    }

    public static AlpsBuilder alps() {
        return new AlpsBuilder();
    }

    public static Descriptor.DescriptorBuilder descriptor() {
        return Descriptor.builder();
    }

    public static Doc.DocBuilder doc() {
        return Doc.builder();
    }

    public static Ext.ExtBuilder ext() {
        return Ext.builder();
    }

    public String getVersion() {
        return this.version;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public List<Descriptor> getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alps alps = (Alps)o;
        return Objects.equals(this.version, alps.version) && Objects.equals(this.doc, alps.doc) && Objects.equals(this.descriptor, alps.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.doc, this.descriptor);
    }

    public String toString() {
        return "Alps(version=" + this.version + ", doc=" + String.valueOf(this.doc) + ", descriptor=" + String.valueOf(this.descriptor) + ")";
    }

    public static class AlpsBuilder {
        private String version;
        private Doc doc;
        private List<Descriptor> descriptor;

        AlpsBuilder() {
        }

        public AlpsBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AlpsBuilder doc(Doc doc) {
            this.doc = doc;
            return this;
        }

        public AlpsBuilder descriptor(List<Descriptor> descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public Alps build() {
            return new Alps(this.version, this.doc, this.descriptor);
        }

        public String toString() {
            return "Alps.AlpsBuilder(version=" + this.version + ", doc=" + String.valueOf(this.doc) + ", descriptor=" + String.valueOf(this.descriptor) + ")";
        }
    }
}

