/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class ExternalUsersListenerImpl
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(ExternalUsersListenerImpl.class);
    private static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";
    private IdentityManager identityManager;

    public void postSave(Membership m, boolean isNew) {
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP)) {
            Identity userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", m.getUserName());
            Profile profile = userIdentity.getProfile();
            if (profile != null) {
                profile.setProperty("external", (Object)String.valueOf(true));
                try {
                    this.getIdentityManager().updateProfile(profile, true);
                }
                catch (Exception e) {
                    LOG.error("Error while saving the external property for user profile {}", new Object[]{m.getUserName(), e});
                }
            }
            this.setExternalUserInUserProfile(m.getUserName(), true);
        }
    }

    public void postDelete(Membership m) {
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP)) {
            Identity userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", m.getUserName());
            Profile profile = userIdentity.getProfile();
            if (profile != null) {
                profile.setProperty("external", (Object)String.valueOf(false));
                try {
                    this.getIdentityManager().updateProfile(profile, true);
                }
                catch (Exception e) {
                    LOG.error("Error while saving the external property for user profile {}", new Object[]{m.getUserName(), e});
                }
            }
            this.setExternalUserInUserProfile(m.getUserName(), false);
        }
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    private void setExternalUserInUserProfile(String userName, boolean external) {
        try {
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            UserProfile userProfile = organizationService.getUserProfileHandler().findUserProfileByName(userName);
            if (userProfile == null) {
                userProfile = organizationService.getUserProfileHandler().createUserProfileInstance(userName);
            }
            userProfile.setAttribute(UserProfile.OTHER_KEYS[2], String.valueOf(external));
            organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
        }
        catch (Exception exception) {
            LOG.error("Error while saving the user.other-info.external property for user profile {}", new Object[]{userName, exception});
        }
    }
}

