/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatsonxServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String apiVersion;
    private final String modelId;
    private final String projectId;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String url;
    public static final JsonpDeserializer<WatsonxServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatsonxServiceSettings::setupWatsonxServiceSettingsDeserializer);

    private WatsonxServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.apiVersion = ApiTypeHelper.requireNonNull(builder.apiVersion, this, "apiVersion");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.projectId = ApiTypeHelper.requireNonNull(builder.projectId, this, "projectId");
        this.rateLimit = builder.rateLimit;
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
    }

    public static WatsonxServiceSettings of(Function<Builder, ObjectBuilder<WatsonxServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String apiVersion() {
        return this.apiVersion;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String projectId() {
        return this.projectId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("api_version");
        generator.write(this.apiVersion);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("project_id");
        generator.write(this.projectId);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("url");
        generator.write(this.url);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWatsonxServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::apiVersion, JsonpDeserializer.stringDeserializer(), "api_version");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::projectId, JsonpDeserializer.stringDeserializer(), "project_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatsonxServiceSettings> {
        private String apiKey;
        private String apiVersion;
        private String modelId;
        private String projectId;
        @Nullable
        private RateLimitSetting rateLimit;
        private String url;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder apiVersion(String value) {
            this.apiVersion = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder projectId(String value) {
            this.projectId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatsonxServiceSettings build() {
            this._checkSingleUse();
            return new WatsonxServiceSettings(this);
        }
    }
}

