/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocaleConfigServiceImpl
implements LocaleConfigService {
    public static final String LOCALE_DEFAULT_MODIFIED_EVENT = "locale.config.default.modified";
    private static final String DEFAULT_LOCALE_CONFIG_PARAM = "locale.config.default";
    private static final Context GLOBAL_SETTINGS_CONTEXT = Context.GLOBAL.id("GLOBAL_SETTINGS");
    private static final Scope GLOBAL_SETTINGS_SCOPE = Scope.APPLICATION.id("GLOBAL_SETTINGS");
    private static final String GLOBAL_SETTINGS_DEFAULT_LANGUAGE = "DEFAULT_LANGUAGE";
    private static final Log LOG = ExoLogger.getLogger(LocaleConfigServiceImpl.class);
    private SettingService settingService;
    private ListenerService listenerService;
    private DocumentBuilderFactory factory;
    private String defaultLocale;
    private LocaleConfig firstConfig;
    private LocaleConfig defaultConfig;
    private Map<String, LocaleConfig> configs;
    private static final Map<String, Orientation> orientations = new HashMap<String, Orientation>();

    public LocaleConfigServiceImpl(SettingService settingService, ListenerService listenerService, ConfigurationManager cmanager, InitParams params) throws Exception {
        this.settingService = settingService;
        this.listenerService = listenerService;
        this.configs = new HashMap<String, LocaleConfig>(10);
        this.factory = DocumentBuilderFactory.newInstance();
        if (params.containsKey((Object)DEFAULT_LOCALE_CONFIG_PARAM)) {
            this.defaultLocale = params.getValueParam(DEFAULT_LOCALE_CONFIG_PARAM).getValue();
        }
        String confResource = params.getValueParam("locale.config.file").getValue();
        InputStream is = cmanager.getInputStream(confResource);
        this.parseConfiguration(is);
    }

    public LocaleConfig getDefaultLocaleConfig() {
        if (this.defaultConfig == null) {
            this.computeDefaultConfig();
        }
        return this.defaultConfig;
    }

    public void saveDefaultLocaleConfig(String locale) {
        String oldDefaultLocale = this.getDefaultLocaleConfig().getLocaleName();
        try {
            if (StringUtils.isBlank((CharSequence)locale)) {
                this.settingService.remove(GLOBAL_SETTINGS_CONTEXT, GLOBAL_SETTINGS_SCOPE, GLOBAL_SETTINGS_DEFAULT_LANGUAGE);
            } else {
                if (!this.configs.containsKey(locale)) {
                    throw new IllegalArgumentException(String.format("Locale %s is not supported", locale));
                }
                this.settingService.set(GLOBAL_SETTINGS_CONTEXT, GLOBAL_SETTINGS_SCOPE, GLOBAL_SETTINGS_DEFAULT_LANGUAGE, SettingValue.create((String)locale));
            }
        }
        finally {
            this.defaultConfig = null;
        }
        String newDefaultLocale = this.getDefaultLocaleConfig().getLocaleName();
        try {
            this.listenerService.broadcast(LOCALE_DEFAULT_MODIFIED_EVENT, (Object)oldDefaultLocale, (Object)newDefaultLocale);
        }
        catch (Exception e) {
            LOG.warn("Error broadcasting locale change from {} to {}", new Object[]{oldDefaultLocale, newDefaultLocale, e});
        }
    }

    public LocaleConfig getLocaleConfig(String lang) {
        return this.configs.getOrDefault(lang, this.getDefaultLocaleConfig());
    }

    public Collection<LocaleConfig> getLocalConfigs() {
        return this.configs.values();
    }

    protected void parseConfiguration(InputStream is) throws Exception {
        this.factory.setIgnoringComments(true);
        this.factory.setCoalescing(true);
        this.factory.setNamespaceAware(false);
        this.factory.setValidating(false);
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        Document document = parser.parse(is);
        NodeList nodes = document.getElementsByTagName("locale-config");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList children = node.getChildNodes();
            LocaleConfigImpl config = new LocaleConfigImpl();
            for (int j = 0; j < children.getLength(); ++j) {
                Node element = children.item(j);
                if ("locale".equals(element.getNodeName())) {
                    config.setLocale(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("output-encoding".equals(element.getNodeName())) {
                    config.setOutputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("input-encoding".equals(element.getNodeName())) {
                    config.setInputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("description".equals(element.getNodeName())) {
                    config.setDescription(element.getFirstChild().getNodeValue());
                    continue;
                }
                if (!"orientation".equals(element.getNodeName())) continue;
                String s = element.getFirstChild().getNodeValue();
                Orientation orientation = orientations.get(s);
                if (orientation == null) {
                    LOG.error((Object)("Wrong orientation value " + s));
                    continue;
                }
                config.setOrientation(orientation);
            }
            if (config.getOrientation() == null) {
                LOG.debug((Object)"No orientation found on the locale config, use the LT default");
                config.setOrientation(Orientation.LT);
            }
            LOG.debug((Object)("Added locale config " + String.valueOf(config) + " to the set of locale configs"));
            String country = config.getLocale().getCountry();
            if (StringUtils.isNotBlank((CharSequence)country)) {
                this.configs.put(config.getLanguage() + "-" + country, config);
            } else {
                this.configs.put(config.getLanguage(), config);
            }
            if (i != 0) continue;
            this.firstConfig = config;
        }
        if (PropertyManager.isDevelopping()) {
            LocaleConfigImpl magicConfig = new LocaleConfigImpl();
            magicConfig.setLocale(IdentityResourceBundle.MAGIC_LOCALE);
            magicConfig.setDescription("Magic locale");
            magicConfig.setInputEncoding("UTF-8");
            magicConfig.setOutputEncoding("UTF-8");
            magicConfig.setDescription("Default configuration for the debugging locale");
            magicConfig.setOrientation(Orientation.LT);
            this.configs.put(magicConfig.getLanguage(), magicConfig);
            LOG.debug((Object)"Added magic locale for debugging bundle usage at runtime");
        }
    }

    private void computeDefaultConfig() {
        SettingValue defaultLanguageValue = this.settingService.get(GLOBAL_SETTINGS_CONTEXT, GLOBAL_SETTINGS_SCOPE, GLOBAL_SETTINGS_DEFAULT_LANGUAGE);
        String localeName = defaultLanguageValue != null && StringUtils.isNotBlank((CharSequence)defaultLanguageValue.getValue().toString()) ? defaultLanguageValue.getValue().toString() : this.defaultLocale;
        if (StringUtils.isNotBlank((CharSequence)localeName)) {
            this.defaultConfig = this.configs.entrySet().stream().filter(configEntry -> StringUtils.equals((CharSequence)((CharSequence)configEntry.getKey()), (CharSequence)localeName)).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        if (this.defaultConfig == null) {
            this.defaultConfig = this.firstConfig;
        }
    }

    static {
        orientations.put("lt", Orientation.LT);
        orientations.put("rt", Orientation.RT);
        orientations.put("tl", Orientation.TL);
        orientations.put("tr", Orientation.TR);
    }
}

