/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import jakarta.servlet.ServletContext;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.resource.AbstractResourceDeployer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.wci.WebApp;

public class JavascriptConfigDeployer
extends AbstractResourceDeployer {
    private static final Log LOG = ExoLogger.getLogger(JavascriptConfigDeployer.class);
    private final JavascriptConfigService javascriptService;
    private final String portalContainerName;

    public JavascriptConfigDeployer(String portalContainerName, JavascriptConfigService javascriptService) {
        this.javascriptService = javascriptService;
        this.portalContainerName = portalContainerName;
    }

    @Override
    protected void add(final WebApp webApp, URL url) {
        try {
            RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext scontext, PortalContainer portalContainer) {
                    JavascriptConfigDeployer.this.register(scontext);
                    JavascriptConfigDeployer.this.javascriptService.registerContext(webApp);
                }
            };
            PortalContainer.addInitTask((ServletContext)webApp.getServletContext(), (RootContainer.PortalContainerInitTask)task, (String)this.portalContainerName);
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occurs while registering 'Javascript in gatein-resources.xml' from the context '" + (webApp.getServletContext() == null ? "unknown" : webApp.getServletContext().getServletContextName()) + "'"), (Throwable)ex);
        }
    }

    @Override
    protected void remove(WebApp webApp) {
        this.javascriptService.unregisterServletContext(webApp);
        try {
            JavascriptConfigParser.unregisterResources(this.javascriptService, webApp.getServletContext());
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occured while removing script resources for the context '" + webApp.getServletContext().getServletContextName() + "'"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ServletContext scontext) {
        InputStream is = null;
        try {
            is = scontext.getResourceAsStream("/WEB-INF/gatein-resources.xml");
            JavascriptConfigParser.processConfigResource(is, this.javascriptService, scontext);
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occurs while processing 'Javascript in gatein-resources.xml' from the context '" + scontext.getServletContextName() + "'"), (Throwable)ex);
        }
        finally {
            Safe.close((Closeable)is);
        }
    }
}

