/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"gamification"})
public class GamificationIntegrationListener
extends Listener<KudosService, Kudos> {
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("exo.kudos.activity", (ListenerBase)this);
        this.listenerService.addListener("kudos.cancel.activity", (ListenerBase)this);
    }

    public void onEvent(Event<KudosService, Kudos> event) {
        Kudos kudos = (Kudos)event.getData();
        String eventName = event.getEventName();
        this.saveSendKudosAchievement(kudos, eventName);
        this.saveRecieveKudosAchievement(kudos, eventName);
    }

    private void saveSendKudosAchievement(Kudos kudos, String eventName) {
        Map<String, String> gam = this.buildGamificationEventDetails("sendKudos", kudos.getSenderId(), "organization", kudos.getReceiverId(), kudos.getReceiverType(), String.valueOf(kudos.getActivityId()));
        this.listenerService.broadcast(this.getGamificationEventName(eventName), gam, (Object)String.valueOf(kudos.getTechnicalId()));
    }

    private void saveRecieveKudosAchievement(Kudos kudos, String eventName) {
        Map<String, String> gam = this.buildGamificationEventDetails("receiveKudos", kudos.getReceiverId(), kudos.getReceiverType(), kudos.getSenderId(), "organization", String.valueOf(kudos.getActivityId()));
        this.listenerService.broadcast(this.getGamificationEventName(eventName), gam, (Object)String.valueOf(kudos.getTechnicalId()));
    }

    private String getGamificationEventName(String eventName) {
        return switch (eventName) {
            case "exo.kudos.activity" -> "exo.gamification.generic.action";
            case "kudos.cancel.activity" -> "gamification.cancel.event.action";
            default -> throw new IllegalArgumentException("Unexpected listener event name: " + eventName);
        };
    }

    private Map<String, String> buildGamificationEventDetails(String gamificationEventName, String earnerId, String earnerType, String receiverId, String receiverType, String objectId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        gam.put("objectType", "activity");
        gam.put("objectId", objectId);
        gam.put("ruleTitle", gamificationEventName);
        gam.put("senderId", earnerId);
        gam.put("senderType", earnerType);
        gam.put("receiverId", receiverId);
        gam.put("receiverType", receiverType);
        return gam;
    }
}

