/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.rest.utils;

import io.meeds.social.notification.rest.model.WebNotificationListRestEntity;
import io.meeds.social.notification.rest.model.WebNotificationRestEntity;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;

public class WebNotificationRestEntityBuilder {
    private WebNotificationRestEntityBuilder() {
    }

    public static WebNotificationRestEntity toRestEntity(WebNotificationService webNotificationService, IdentityManager identityManager, SpaceService spaceService, NotificationInfo notification, boolean isOnPopover) {
        Identity identity = WebNotificationRestEntityBuilder.getSender(identityManager, notification);
        Space space = WebNotificationRestEntityBuilder.getSpace(spaceService, notification);
        ProfileEntity profileEntity = identity == null ? null : EntityBuilder.buildEntityProfile((Profile)identity.getProfile(), null);
        SpaceEntity spaceEntity = space == null ? null : EntityBuilder.buildEntityFromSpace((Space)space, null, null, null);
        return new WebNotificationRestEntity(notification.getId(), notification.getTitle(), notification.getKey().getId(), profileEntity, spaceEntity, webNotificationService.getNotificationMessage(notification, isOnPopover), notification.getOwnerParameter(), notification.isRead(), notification.isMutable(), notification.isSpaceMuted(), notification.getLastModifiedDate());
    }

    public static WebNotificationListRestEntity toRestEntity(WebNotificationService webNftService, IdentityManager identityManager, SpaceService spaceService, List<NotificationInfo> notificationInfos, boolean isOnPopover, int badge, Map<String, Integer> badgesByPlugin, int offset, int limit) {
        return new WebNotificationListRestEntity(notificationInfos.stream().map(notification -> WebNotificationRestEntityBuilder.toRestEntity(webNftService, identityManager, spaceService, notification, isOnPopover)).toList(), badge, badgesByPlugin, offset, limit);
    }

    private static Identity getSender(IdentityManager identityManager, NotificationInfo notification) {
        String username = notification.getFrom();
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("poster");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("username");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("profile");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("sender");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("modifier");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("MODIFIER_ID");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("SENDER_ID");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("request_from");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("likersId");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("creator");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = (String)notification.getOwnerParameter().get("creatorId");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        Identity identity = identityManager.getOrCreateUserIdentity(username);
        if (identity != null) {
            return identity;
        }
        if (StringUtils.isNumeric((CharSequence)username)) {
            return identityManager.getIdentity(username);
        }
        return null;
    }

    private static Space getSpace(SpaceService spaceService, NotificationInfo notification) {
        ExoSocialActivity activity;
        String spaceId = (String)notification.getOwnerParameter().get("spaceId");
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            return spaceService.getSpaceById(spaceId);
        }
        String spacePrettyName = (String)notification.getOwnerParameter().get("prettyName");
        if (StringUtils.isNotBlank((CharSequence)spacePrettyName)) {
            return spaceService.getSpaceByPrettyName(spacePrettyName);
        }
        String activityId = (String)notification.getOwnerParameter().get("activityId");
        if (StringUtils.isNotBlank((CharSequence)activityId) && StringUtils.isNumeric((CharSequence)activityId) && (activity = Utils.getActivityManager().getActivity(activityId)) != null && activity.getActivityStream() != null && activity.getActivityStream().isSpace() && StringUtils.isNotBlank((CharSequence)(spaceId = activity.getSpaceId()))) {
            return spaceService.getSpaceById(spaceId);
        }
        return null;
    }
}

