/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.info;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ProductInformations
implements Startable {
    public static final String PRODUCT_INFORMATION = "ProductInformation";
    public static final String ENTERPRISE_EDITION = "ENTERPRISE";
    public static final String EXPRESS_EDITION = "EXPRESS";
    public static final String EDITION = "edition";
    public static final String KEY_GENERATION_DATE = "key generation date";
    public static final String DELAY = "delay";
    public static final String PRODUCT_CODE = "productCode";
    public static final String PRODUCT_KEY = "productKey";
    public static final String NB_USERS = "number of users";
    public static final String PRODUCT_NAME = "product.name";
    public static final String PRODUCT_LINK = "product.link";
    public static final String PRODUCT_GROUP_ID = "product.groupId";
    public static final String PRODUCT_REVISION = "product.revision";
    public static final String PRODUCT_BUILD_NUMBER = "product.buildNumber";
    public static final String WORKING_WORSPACE_NAME = "working.worspace.name";
    public static final String PRODUCT_VERSIONS_DECLARATION_FILE = "product.versions.declaration.file";
    public static final String UPGRADE_PRODUCT_SERVICE_NODE_NAME = "ProductInformationsService";
    public static final String PRODUCT_VERSION_DECLARATION_NODE_NAME = "productVersionDeclarationNode";
    private static final Log LOG = ExoLogger.getLogger(ProductInformations.class);
    private Properties productInformationProperties;
    private Map<String, String> productInformation;
    private boolean firstRun;
    private SettingService settingService;

    public ProductInformations(ConfigurationManager cmanager, InitParams initParams, SettingService settingService) {
        block7: {
            this.productInformationProperties = new Properties();
            this.productInformation = new HashMap<String, String>();
            this.firstRun = false;
            this.settingService = settingService;
            if (!initParams.containsKey((Object)PRODUCT_VERSIONS_DECLARATION_FILE)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Couldn't find the init value param: product.versions.declaration.file");
                }
                return;
            }
            String filePath = initParams.getValueParam(PRODUCT_VERSIONS_DECLARATION_FILE).getValue();
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Read products versions from " + filePath));
                }
                InputStream inputStream = cmanager.getInputStream(filePath);
                this.productInformationProperties.load(inputStream);
            }
            catch (IOException exception) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Couldn't parse the file " + filePath), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)("Error occured while reading the file " + filePath), (Throwable)exception);
            }
        }
    }

    public String getEdition() {
        return this.productInformation.get(EDITION);
    }

    public String getNumberOfUsers() {
        return this.productInformation.get(NB_USERS);
    }

    public String getDateOfLicence() {
        return this.productInformation.get(KEY_GENERATION_DATE);
    }

    public String getDuration() {
        return this.productInformation.get(DELAY);
    }

    public String getProductCode() {
        return this.productInformation.get(PRODUCT_CODE);
    }

    public String getProductKey() {
        return this.productInformation.get(PRODUCT_KEY);
    }

    public String getVersion() throws MissingProductInformationException {
        return this.getVersion(this.getCurrentProductGroupId());
    }

    public String getVersion(String productGroupId) throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(productGroupId)) {
            throw new MissingProductInformationException(productGroupId);
        }
        return this.productInformationProperties.getProperty(productGroupId);
    }

    public String getBuildNumber() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_BUILD_NUMBER)) {
            throw new MissingProductInformationException(PRODUCT_BUILD_NUMBER);
        }
        return this.productInformationProperties.getProperty(PRODUCT_BUILD_NUMBER);
    }

    public String getRevision() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_REVISION)) {
            throw new MissingProductInformationException(PRODUCT_REVISION);
        }
        return this.productInformationProperties.getProperty(PRODUCT_REVISION);
    }

    public String getCurrentProductGroupId() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_GROUP_ID)) {
            throw new MissingProductInformationException(PRODUCT_GROUP_ID);
        }
        return this.productInformationProperties.getProperty(PRODUCT_GROUP_ID);
    }

    public String getProductName() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_NAME)) {
            throw new MissingProductInformationException(PRODUCT_NAME);
        }
        return this.productInformationProperties.getProperty(PRODUCT_NAME);
    }

    public String getProductLink() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_LINK)) {
            throw new MissingProductInformationException(PRODUCT_LINK);
        }
        return this.productInformationProperties.getProperty(PRODUCT_LINK);
    }

    public String getPreviousVersion() throws MissingProductInformationException {
        return this.getPreviousVersion(this.getCurrentProductGroupId());
    }

    public String getPreviousVersion(String productGroupId) throws MissingProductInformationException {
        if (!this.productInformation.containsKey(productGroupId)) {
            throw new MissingProductInformationException(productGroupId);
        }
        return this.productInformation.get(productGroupId);
    }

    public String getPreviousProductName() throws MissingProductInformationException {
        if (!this.productInformation.containsKey(PRODUCT_NAME)) {
            throw new MissingProductInformationException(PRODUCT_NAME);
        }
        return this.productInformation.get(PRODUCT_NAME);
    }

    public String getPreviousProductLink() throws MissingProductInformationException {
        if (!this.productInformation.containsKey(PRODUCT_LINK)) {
            throw new MissingProductInformationException(PRODUCT_LINK);
        }
        return this.productInformation.get(PRODUCT_LINK);
    }

    public String getPreviousBuildNumber() throws MissingProductInformationException {
        if (!this.productInformation.containsKey(PRODUCT_BUILD_NUMBER)) {
            throw new MissingProductInformationException(PRODUCT_BUILD_NUMBER);
        }
        return this.productInformation.get(PRODUCT_BUILD_NUMBER);
    }

    public String getPreviousRevision() throws MissingProductInformationException {
        if (!this.productInformation.containsKey(PRODUCT_REVISION)) {
            throw new MissingProductInformationException(PRODUCT_REVISION);
        }
        return this.productInformation.get(PRODUCT_REVISION);
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public void start() {
        try {
            Map productInformationSettings = this.settingService.getSettingsByContextAndScope(Context.GLOBAL.getName(), Context.GLOBAL.getId(), Scope.APPLICATION.getName(), PRODUCT_INFORMATION);
            if (productInformationSettings != null && !productInformationSettings.isEmpty()) {
                productInformationSettings.entrySet().stream().forEach(e -> this.productInformation.put((String)e.getKey(), ((SettingValue)e.getValue()).getValue().toString()));
            } else {
                LOG.info((Object)"Platform first run - init and store product Information");
                this.firstRun = true;
                this.initProductInformation(this.productInformationProperties);
                this.storeProductInformation(this.productInformation);
            }
        }
        catch (Exception e2) {
            LOG.error((Object)("Error while starting product information service - Cause : " + e2.getMessage()), (Throwable)e2);
        }
    }

    public void stop() {
    }

    public void storeProductInformation(Map<String, String> map) {
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id(PRODUCT_INFORMATION), entry.getKey(), SettingValue.create((String)entry.getValue()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while storing product informations    - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    public void initProductInformation(Properties properties) {
        properties.entrySet().stream().forEach(entry -> this.productInformation.put((String)entry.getKey(), (String)entry.getValue()));
    }

    public void setUnlockInformation(Properties unlockInformation) {
        this.productInformation.put(EDITION, (String)unlockInformation.get(EDITION));
        this.productInformation.put(NB_USERS, (String)unlockInformation.get(NB_USERS));
        this.productInformation.put(PRODUCT_KEY, (String)unlockInformation.get(PRODUCT_KEY));
        this.productInformation.put(PRODUCT_CODE, (String)unlockInformation.get(PRODUCT_CODE));
        this.productInformation.put(DELAY, (String)unlockInformation.get(DELAY));
        this.productInformation.put(KEY_GENERATION_DATE, (String)unlockInformation.get(KEY_GENERATION_DATE));
    }

    public void setPreviousVersionsIfFirstRun(String defaultVersion) {
        if (this.isFirstRun()) {
            this.initProductInformation(this.productInformationProperties);
            this.productInformation.forEach((key, value) -> this.productInformation.put((String)key, defaultVersion));
        }
    }

    public void setProductInformationProperties(Properties productInformationProperties) {
        this.productInformationProperties = productInformationProperties;
    }

    public Properties getProductInformationProperties() {
        return this.productInformationProperties;
    }

    public Map<String, String> getProductInformation() {
        return this.productInformation;
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }
}

