/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.storage;

import io.meeds.social.cms.model.ContentLinkIdentifier;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.model.ContentObjectIdentifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentLinkStorage {
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_LOCALE = "fieldLocale";
    private static final MetadataType METADATA_TYPE = new MetadataType(579645L, "contentLink");
    @Autowired
    private MetadataService metadataService;

    public void saveLinks(ContentObject contentObject, List<? extends ContentObjectIdentifier> links) {
        Metadata metadata = this.metadataService.getMetadataByKey(this.getMetadataKey((ContentObjectIdentifier)contentObject));
        if (metadata == null) {
            metadata = new Metadata();
            metadata.setType(METADATA_TYPE);
            metadata.setName(this.getMetadataName((ContentObjectIdentifier)contentObject));
            this.metadataService.createMetadata(metadata);
        } else {
            this.deleteLinks((ContentObjectIdentifier)contentObject);
        }
        links.forEach(link -> this.createMetadataItem(contentObject, (ContentObjectIdentifier)link));
    }

    public void deleteLinks(ContentObjectIdentifier contentObjectIdentifier) {
        ContentObject contentObject;
        if (contentObjectIdentifier instanceof ContentObject && StringUtils.isNotBlank((CharSequence)(contentObject = (ContentObject)contentObjectIdentifier).getFieldName())) {
            List items = this.metadataService.getMetadataItemsByMetadata(this.getMetadataKey((ContentObjectIdentifier)contentObject), 0, 0);
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                String fieldName = contentObject.getFieldName();
                boolean noLocaleFiltering = contentObject.getLocale() == null;
                boolean noFieldNameFiltering = StringUtils.isBlank((CharSequence)fieldName);
                for (MetadataItem item : items) {
                    if (!noFieldNameFiltering && !StringUtils.equals((CharSequence)fieldName, (CharSequence)MapUtils.getString((Map)item.getProperties(), (Object)FIELD_NAME)) || !noLocaleFiltering && !contentObject.getLocale().toLanguageTag().equals(MapUtils.getString((Map)item.getProperties(), (Object)FIELD_LOCALE))) continue;
                    this.metadataService.deleteMetadataItem(item.getId(), false);
                }
            }
        } else {
            MetadataKey metadataKey = this.getMetadataKey(contentObjectIdentifier);
            this.metadataService.deleteMetadataItemsByMetadata(metadataKey.getType(), metadataKey.getName());
        }
    }

    public List<ContentLinkIdentifier> getLinkIdentifiers(ContentObject contentObject) {
        Locale locale;
        List items = this.metadataService.getMetadataItemsByMetadata(this.getMetadataKey((ContentObjectIdentifier)contentObject), 0, 0);
        Stream<Object> itemsStream = items.stream();
        String fieldName = contentObject.getFieldName();
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            itemsStream = itemsStream.filter(item -> StringUtils.equals((CharSequence)MapUtils.getString((Map)item.getProperties(), (Object)FIELD_NAME), (CharSequence)fieldName));
        }
        if ((locale = contentObject.getLocale()) != null) {
            String lang = locale.toLanguageTag();
            itemsStream = itemsStream.filter(item -> {
                String linkLocale = MapUtils.getString((Map)item.getProperties(), (Object)FIELD_LOCALE);
                return StringUtils.isBlank((CharSequence)linkLocale) || StringUtils.equals((CharSequence)linkLocale, (CharSequence)lang);
            });
        }
        return itemsStream.map(item -> new ContentLinkIdentifier(item.getObjectType(), item.getObjectId(), MapUtils.getString((Map)item.getProperties(), (Object)FIELD_NAME), LocaleUtils.toLocale((String)MapUtils.getString((Map)item.getProperties(), (Object)FIELD_LOCALE)))).toList();
    }

    private void createMetadataItem(ContentObject contentObject, ContentObjectIdentifier link) {
        MetadataObject metadataObject = this.getMetadataObject(link);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)contentObject.getFieldName())) {
            properties.put(FIELD_NAME, contentObject.getFieldName());
        }
        if (contentObject.getLocale() != null) {
            properties.put(FIELD_LOCALE, contentObject.getLocale().toLanguageTag());
        }
        this.metadataService.createMetadataItem(metadataObject, this.getMetadataKey((ContentObjectIdentifier)contentObject), properties);
    }

    private MetadataObject getMetadataObject(ContentObjectIdentifier link) {
        return new MetadataObject(link.getObjectType(), link.getObjectId());
    }

    private MetadataKey getMetadataKey(ContentObjectIdentifier contentObject) {
        return new MetadataKey(METADATA_TYPE.getName(), this.getMetadataName(contentObject), 0L);
    }

    private String getMetadataName(ContentObjectIdentifier contentObject) {
        return String.format("%s:%s", contentObject.getObjectType(), contentObject.getObjectId());
    }
}

