/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.model.constant;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import org.exoplatform.perkstore.model.ProductOrderPeriod;
import org.exoplatform.perkstore.service.utils.Utils;

public enum ProductOrderPeriodType {
    WEEK("Week", "week"),
    MONTH("Month", "month"),
    QUARTER("Quarter", "quarter"),
    SEMESTER("Semester", "semester"),
    YEAR("Year", "year"),
    NONE("None", "none");

    private String name;
    private String label;

    private ProductOrderPeriodType(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public ProductOrderPeriod getPeriodOfTime(LocalDateTime localDateTime) {
        ProductOrderPeriod productPeriod = new ProductOrderPeriod();
        YearMonth yearMonth = YearMonth.from(localDateTime);
        switch (this.ordinal()) {
            case 0: {
                LocalDateTime firstDayOfThisWeek = localDateTime.toLocalDate().with(DayOfWeek.MONDAY).atStartOfDay();
                LocalDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                productPeriod.setStartDate(Utils.timeToMilliseconds(firstDayOfThisWeek));
                productPeriod.setEndDate(Utils.timeToMilliseconds(firstDayOfNextWeek));
                break;
            }
            case 1: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                productPeriod.setStartDate(Utils.timeToMilliseconds(currentMonth.atDay(1).atStartOfDay()));
                productPeriod.setEndDate(Utils.timeToMilliseconds(nextMonth.atDay(1).atStartOfDay()));
                break;
            }
            case 2: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                productPeriod.setStartDate(Utils.timeToMilliseconds(startQuarterMonth.atDay(1).atStartOfDay()));
                productPeriod.setEndDate(Utils.timeToMilliseconds(endQuarterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case 3: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                productPeriod.setStartDate(Utils.timeToMilliseconds(startSemesterMonth.atDay(1).atStartOfDay()));
                productPeriod.setEndDate(Utils.timeToMilliseconds(endSemesterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case 4: {
                productPeriod.setStartDate(Utils.timeToMilliseconds(Year.from(localDateTime).atDay(1).atStartOfDay()));
                productPeriod.setEndDate(Utils.timeToMilliseconds(Year.from(localDateTime).plusYears(1L).atDay(1).atStartOfDay()));
                break;
            }
        }
        return productPeriod;
    }
}

