/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.listener;

import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.service.WalletTransactionService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;

public class TransactionCreatedListener
extends Listener<Object, TransactionDetail> {
    private ListenerService listenerService;
    private WalletTransactionService transactionService;

    public TransactionCreatedListener(ListenerService listenerService, WalletTransactionService transactionService) {
        this.listenerService = listenerService;
        this.transactionService = transactionService;
    }

    public void onEvent(Event<Object, TransactionDetail> event) throws Exception {
        TransactionDetail transactionDetail = (TransactionDetail)event.getData();
        this.transactionService.cancelTransactionsWithSameNonce(transactionDetail);
        if (StringUtils.isBlank((CharSequence)transactionDetail.getRawTransaction()) && transactionDetail.isPending()) {
            this.listenerService.broadcast("exo.wallet.transaction.sent", (Object)transactionDetail, (Object)transactionDetail);
        }
    }
}

