/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.meeds.chat.entity.RoomStatus;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.MediaInfo;
import io.meeds.chat.service.utils.MatrixHttpClient;
import io.meeds.chat.storage.MatrixRoomStorage;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatrixService {
    private static final Log LOG = ExoLogger.getLogger(MatrixService.class);
    @Autowired
    private MatrixRoomStorage matrixRoomStorage;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private IdentityStorage identityStorage;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private MatrixHttpClient matrixHttpClient;
    private boolean serviceAvailable;
    private String matrixAccessToken;
    private final ExoCache<String, String> userMatrixIdsCache;
    public static final String USER_MATRIX_ID_CACHE_NAME = "chat.UserMatrixId";

    public MatrixService(MatrixRoomStorage matrixRoomStorage, IdentityManager identityManager, IdentityStorage identityStorage, OrganizationService organizationService, MatrixHttpClient matrixHttpClient, CacheService cacheService) {
        this.matrixRoomStorage = matrixRoomStorage;
        this.identityManager = identityManager;
        this.identityStorage = identityStorage;
        this.organizationService = organizationService;
        this.matrixHttpClient = matrixHttpClient;
        this.userMatrixIdsCache = cacheService.getCacheInstance(USER_MATRIX_ID_CACHE_NAME);
    }

    @PostConstruct
    public void init() {
        try {
            this.getMatrixAccessToken();
            String userFullMatrixID = this.getUserFullMatrixID(PropertyManager.getProperty((String)"meeds.matrix.user.name"));
            this.overrideAdminRateLimit(userFullMatrixID);
            String displayName = System.getProperty("meeds.matrix.user.display.name", "Chat Bot");
            if (StringUtils.isNotBlank((CharSequence)displayName)) {
                this.updateUserDisplayName(userFullMatrixID, displayName);
            }
            this.serviceAvailable = true;
        }
        catch (Exception e) {
            LOG.error("Could not initialize Matrix service, the service is unavailable", new Object[]{e.getMessage()});
            this.serviceAvailable = false;
        }
    }

    public String getUserFullMatrixID(String userName) {
        if (StringUtils.isNotBlank((CharSequence)userName) && userName.startsWith("@") && userName.indexOf(":") > 0) {
            return userName;
        }
        return "@" + userName + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
    }

    private String getMatrixAccessToken() throws JsonException, IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)this.matrixAccessToken)) {
            try {
                String jwtAccessToken = this.getJWTSessionToken(PropertyManager.getProperty((String)"meeds.matrix.user.name"));
                this.matrixAccessToken = this.matrixHttpClient.getAccessToken(jwtAccessToken);
            }
            catch (IOException | JsonException e) {
                LOG.error((Object)"Could not get Matrix Access token for the administrator account !", e);
                throw e;
            }
        }
        return this.matrixAccessToken;
    }

    public String getAccessToken(String jwtToken) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.getAccessToken(jwtToken);
    }

    public boolean invalidateAccessToken(String accessToken) {
        try {
            return this.matrixHttpClient.invalidateAccessToken(accessToken);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not invalidate an access token !", (Throwable)e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LOG.error((Object)"Could not invalidate an access token !", (Throwable)interruptedException);
            return false;
        }
    }

    public void updateUserDisplayName(String matrixFullID, String newDisplayName) {
        try {
            String currentUserDisplayName = this.matrixHttpClient.getUserDisplayName(matrixFullID, this.getMatrixAccessToken());
            if (StringUtils.isNotBlank((CharSequence)currentUserDisplayName) && !currentUserDisplayName.equals(newDisplayName)) {
                this.matrixHttpClient.updateUserDisplayName(matrixFullID, newDisplayName, this.getMatrixAccessToken());
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Couldn't update the display name of the user {}", new Object[]{matrixFullID, ie});
        }
        catch (Exception e) {
            LOG.error("Couldn't update the display name of the user {}", new Object[]{matrixFullID, e});
        }
    }

    public Room getRoomBySpace(Space space) {
        return this.getRoomBySpaceId(space.getId());
    }

    public Room getRoomBySpace(Space space, boolean includeDisabled) {
        return this.getRoomBySpaceId(space.getId(), includeDisabled);
    }

    public Room getRoomBySpaceId(String spaceId) {
        return this.getRoomBySpaceId(spaceId, false);
    }

    public Room getRoomBySpaceId(String spaceId, boolean includeDisabled) {
        return this.matrixRoomStorage.getMatrixRoomBySpaceId(spaceId, includeDisabled);
    }

    public Room getById(String roomId) {
        return this.getById(roomId, false);
    }

    public Room getById(String roomId, boolean includeDisabled) {
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            roomId = this.extractRoomId(roomId);
            return this.matrixRoomStorage.getById(roomId, includeDisabled);
        }
        return null;
    }

    public Room linkSpaceToMatrixRoom(Space space, String roomId) {
        return this.matrixRoomStorage.saveRoomForSpace(space.getId(), roomId);
    }

    public String createRoomForSpaceOnMatrix(Space space) throws Exception {
        String teamDisplayName = space.getDisplayName();
        String description = space.getDescription() != null ? space.getDescription() : "";
        return this.matrixHttpClient.createRoom(teamDisplayName, description, this.getMatrixAccessToken());
    }

    public String getMatrixIdForUser(String userName) {
        Identity newMember = this.identityManager.getOrCreateUserIdentity(userName);
        Profile newMemberProfile = newMember.getProfile();
        if (StringUtils.isNotBlank((CharSequence)((String)newMemberProfile.getProperty("matrixId")))) {
            return newMemberProfile.getProperty("matrixId").toString();
        }
        return null;
    }

    public String getJWTSessionToken(String userNameOnMatrix) {
        Date expirtaionDate = Date.from(Instant.now().plusSeconds(604800L));
        userNameOnMatrix = userNameOnMatrix.replaceAll("[^a-zA-Z0-9=_\\-\\.\\/+]+", "-");
        return Jwts.builder().setSubject(userNameOnMatrix).signWith((Key)Keys.hmacShaKeyFor((byte[])PropertyManager.getProperty((String)"meeds.matrix.jwt.secret").getBytes())).setExpiration(expirtaionDate).compact();
    }

    public String saveUserAccount(Identity user, boolean isNew) throws JsonException, IOException, InterruptedException {
        return this.saveUserAccount(user, isNew, false, true);
    }

    public String saveUserAccount(Identity user, boolean isNew, boolean isEnableUserOperation, boolean isUserEnabled) throws JsonException, IOException, InterruptedException {
        Object matrixUserId = user.getRemoteId();
        if (StringUtils.isNumeric((CharSequence)user.getRemoteId())) {
            String prefix = StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.username.prefix")) ? PropertyManager.getProperty((String)"meeds.matrix.username.prefix") : "u";
            matrixUserId = prefix + user.getRemoteId();
        }
        matrixUserId = this.cleanMatrixUsername((String)matrixUserId);
        String matrixId = this.matrixHttpClient.saveUserAccount(user, (String)matrixUserId, isNew, this.getMatrixAccessToken(), isEnableUserOperation, isUserEnabled);
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getRemoteId());
        Profile userProfile = userIdentity.getProfile();
        if (StringUtils.isNotBlank((CharSequence)matrixId) && (userProfile.getProperty("matrixId") == null || StringUtils.isBlank((CharSequence)userProfile.getProperty("matrixId").toString()))) {
            userProfile.getProperties().put("matrixId", matrixId);
            this.identityManager.updateProfile(userProfile);
        }
        return matrixId;
    }

    public String uploadFileOnMatrix(String fileName, String mimeType, byte[] fileBytes) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.uploadFile(fileName, mimeType, fileBytes, this.getMatrixAccessToken());
    }

    public void updateUserAvatar(Profile profile, String userMatrixID) throws JsonException, IOException, InterruptedException {
        try {
            if (StringUtils.isNotBlank((CharSequence)userMatrixID)) {
                FileItem avatarFileItem = this.identityStorage.getAvatarFile(profile.getIdentity());
                String mimeType = "image/jpg";
                if (avatarFileItem != null && avatarFileItem.getFileInfo() != null && !"DEFAULT_AVATAR".equals(avatarFileItem.getFileInfo().getName())) {
                    if (!"application/octet-stream".equals(avatarFileItem.getFileInfo().getMimetype())) {
                        mimeType = avatarFileItem.getFileInfo().getMimetype();
                    }
                    String userAvatarUrl = this.uploadFileOnMatrix("avatar-of-" + profile.getIdentity().getRemoteId() + ".jpg", mimeType, avatarFileItem.getAsByte());
                    if (StringUtils.isNotBlank((CharSequence)userMatrixID) && StringUtils.isNotBlank((CharSequence)userAvatarUrl)) {
                        this.matrixHttpClient.updateUserAvatar(userMatrixID, userAvatarUrl, this.getMatrixAccessToken());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not save the avatar of {} on Matrix", new Object[]{profile.getFullName(), e});
        }
    }

    public void disableAccount(String matrixUsername) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.disableAccount(matrixUsername, false, this.getMatrixAccessToken());
    }

    public boolean updateRoomDescription(String roomId, String description) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.updateRoomDescription(roomId, description, this.getMatrixAccessToken());
    }

    public void updateRoomAvatar(Space space, String roomId) throws Exception {
        String mimeType = "";
        String fileExtension = "";
        String fileName = "";
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            FileItem spaceAvatarFileItem = this.identityManager.getAvatarFile(identity);
            byte[] imageBytes = new byte[]{};
            if (space.getAvatarAttachment() != null && space.getAvatarAttachment().getImageBytes() != null) {
                imageBytes = space.getAvatarAttachment().getImageBytes();
                mimeType = space.getAvatarAttachment().getMimeType();
                fileName = space.getAvatarAttachment().getFileName();
                fileExtension = StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : ".jpg";
            } else if (spaceAvatarFileItem != null && spaceAvatarFileItem.getAsByte() != null) {
                imageBytes = spaceAvatarFileItem.getAsByte();
                mimeType = spaceAvatarFileItem.getFileInfo().getMimetype();
                fileName = spaceAvatarFileItem.getFileInfo().getName();
                String string = fileExtension = StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : ".jpg";
            }
            if ("application/octet-stream".equals(mimeType)) {
                mimeType = "image/jpg";
            }
            fileName = "avatar-space-%s%s".formatted(space.getPrettyName(), fileExtension);
            if (StringUtils.isNotBlank((CharSequence)roomId) && imageBytes != null) {
                String avatarURL = this.uploadFileOnMatrix(fileName, mimeType, imageBytes);
                this.matrixHttpClient.updateRoomAvatar(roomId, avatarURL, this.getMatrixAccessToken());
            }
        }
        catch (Exception e) {
            throw new Exception("Could not save the avatar of the space %s".formatted(space.getDisplayName()), e);
        }
    }

    public MatrixRoomPermissions getRoomSettings(String roomId) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.getRoomSettings(roomId, this.getMatrixAccessToken());
    }

    public boolean updateRoomSettings(String roomId, MatrixRoomPermissions matrixRoomPermissions) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.updateRoomSettings(roomId, matrixRoomPermissions, this.getMatrixAccessToken()) != null;
    }

    public void kickUserFromRoom(String roomId, String matrixIdOfUser, String message) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.kickUserFromRoom(roomId, matrixIdOfUser, message, this.getMatrixAccessToken());
    }

    public void joinUserToRoom(String roomId, String matrixIdOfUser) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.joinUserToRoom(roomId, matrixIdOfUser, this.getMatrixAccessToken());
    }

    public void renameRoom(String roomId, String spaceDisplayName) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.renameRoom(roomId, spaceDisplayName, this.getMatrixAccessToken());
    }

    public void makeUserAdminInRoom(String matrixRoomId, String matrixIdOfUser) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.makeUserAdminInRoom(matrixRoomId, matrixIdOfUser, this.getMatrixAccessToken());
    }

    public String createRoom(Space space) throws Exception {
        String description;
        String teamDisplayName = space.getDisplayName();
        String matrixRoomId = this.matrixHttpClient.createRoom(teamDisplayName, description = space.getDescription() != null ? space.getDescription() : "", this.getMatrixAccessToken());
        if (StringUtils.isNotBlank((CharSequence)matrixRoomId)) {
            this.linkSpaceToMatrixRoom(space, matrixRoomId);
            MatrixRoomPermissions matrixRoomPermissions = this.getRoomSettings(matrixRoomId);
            matrixRoomPermissions.setInvite("100");
            this.updateRoomSettings(matrixRoomId, matrixRoomPermissions);
        }
        return matrixRoomId;
    }

    public Room getDirectMessagingRoom(String firstParticipant, String secondParticipant) {
        return this.matrixRoomStorage.getDirectMessagingRoom(firstParticipant, secondParticipant);
    }

    public void deleteRoom(String roomId) throws JsonException, IOException, InterruptedException {
        boolean success = this.matrixHttpClient.deleteRoom(roomId, this.getMatrixAccessToken());
        if (success) {
            this.matrixRoomStorage.removeMatrixRoom(roomId);
        }
    }

    public Room createDirectMessagingRoom(Room directMessagingRoom) throws ObjectAlreadyExistsException {
        String firstParticipant = directMessagingRoom.getFirstParticipant();
        String secondParticipant = directMessagingRoom.getSecondParticipant();
        if (StringUtils.isBlank((CharSequence)firstParticipant) || StringUtils.isBlank((CharSequence)secondParticipant)) {
            throw new IllegalArgumentException("The ids of the room participants should not be null");
        }
        if (this.identityManager.getOrCreateUserIdentity(directMessagingRoom.getFirstParticipant()) == null || this.identityManager.getOrCreateUserIdentity(directMessagingRoom.getSecondParticipant()) == null) {
            throw new IllegalArgumentException("The ids of the room participants should be valid user identity ids");
        }
        Room matrixRoom = this.matrixRoomStorage.getDirectMessagingRoom(firstParticipant, secondParticipant);
        if (matrixRoom == null) {
            return this.matrixRoomStorage.saveDirectMessagingRoom(directMessagingRoom.getFirstParticipant(), directMessagingRoom.getSecondParticipant(), directMessagingRoom.getRoomId());
        }
        throw new ObjectAlreadyExistsException((Object)"A direct messaging room is already created for the users %s and %s".formatted(firstParticipant, secondParticipant));
    }

    public List<Room> getMatrixDMRoomsOfUser(String user) {
        return this.matrixRoomStorage.getMatrixDMRoomsOfUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserMemberOfGroup(String userName, String groupId) throws Exception {
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            Collection userMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(userName, groupId);
            boolean bl = !userMemberships.isEmpty();
            return bl;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean isUserMemberOfGroups(String userName, String ... groups) throws Exception {
        for (String group : groups) {
            if (!this.isUserMemberOfGroup(userName, group)) continue;
            return true;
        }
        return false;
    }

    public List<Room> getSpaceRooms() {
        return this.matrixRoomStorage.getSpaceRooms();
    }

    public String extractUserId(String fullMatrixUserId) {
        String serverName = PropertyManager.getProperty((String)"meeds.matrix.server.name");
        if (fullMatrixUserId.startsWith("@") && fullMatrixUserId.endsWith(serverName)) {
            return fullMatrixUserId.substring(1, fullMatrixUserId.indexOf(":"));
        }
        return fullMatrixUserId;
    }

    public String extractRoomId(String fullMatrixUserId) {
        String serverName = PropertyManager.getProperty((String)"meeds.matrix.server.name");
        if (fullMatrixUserId.startsWith("!") && fullMatrixUserId.endsWith(serverName)) {
            return fullMatrixUserId.substring(0, fullMatrixUserId.indexOf(":"));
        }
        return fullMatrixUserId;
    }

    public String updateUserPresence(String userIdOnMatrix, String presence, String statusMessage) {
        try {
            return this.matrixHttpClient.setUserPresence(userIdOnMatrix, presence, statusMessage, this.getMatrixAccessToken());
        }
        catch (Exception e) {
            LOG.error("Could not update the presence onf the user {} on Matrix", new Object[]{userIdOnMatrix, e});
            return null;
        }
    }

    public boolean canAccess(Room room, String userName) {
        if (StringUtils.isBlank((CharSequence)room.getSpaceId())) {
            return userName.equals(room.getFirstParticipant()) || userName.equals(room.getSecondParticipant());
        }
        Space space = this.spaceService.getSpaceById(room.getSpaceId());
        return this.spaceService.canViewSpace(space, userName);
    }

    public Room enableSpaceChat(Space space, boolean enable) throws ObjectNotFoundException {
        if (space == null) {
            throw new IllegalArgumentException("The space should not be null");
        }
        Room spaceRoom = this.getRoomBySpace(space, true);
        if (spaceRoom == null) {
            throw new ObjectNotFoundException("Could not find a chat room for the space " + space.getDisplayName());
        }
        String matrixAdminUsername = PropertyManager.getProperty((String)"meeds.matrix.user.name");
        RoomStatus currentRoomStatus = RoomStatus.valueOf(spaceRoom.getStatus());
        this.changeRoomStatus(spaceRoom.getRoomId(), enable ? RoomStatus.ENABLE_IN_PROGRESS : RoomStatus.DISABLED_IN_PROGRESS);
        try {
            for (String member : space.getMembers()) {
                String matrixIdOfMember = this.getMatrixIdForUser(member);
                if (matrixAdminUsername.equals(matrixIdOfMember)) continue;
                try {
                    if (enable) {
                        this.joinUserToRoom(spaceRoom.getRoomId(), matrixIdOfMember);
                        continue;
                    }
                    this.kickUserFromRoom(spaceRoom.getRoomId(), matrixIdOfMember, "the Chat was disabled for the space %s, thus the user %s is removed from the chat members".formatted(space.getDisplayName(), member));
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    LOG.error("couldn't invite / remove the user {} from the room {}", new Object[]{matrixAdminUsername, spaceRoom.getRoomId(), e});
                }
            }
            spaceRoom = this.changeRoomStatus(spaceRoom.getRoomId(), enable ? RoomStatus.ENABLED : RoomStatus.DISABLED);
        }
        catch (Exception e) {
            spaceRoom = this.changeRoomStatus(spaceRoom.getRoomId(), currentRoomStatus);
            LOG.error("An error occurred when enabling/disabling the room {}", new Object[]{matrixAdminUsername, spaceRoom.getRoomId(), e});
        }
        return spaceRoom;
    }

    private Room changeRoomStatus(String roomId, RoomStatus status) {
        return this.matrixRoomStorage.setRoomEnabled(roomId, status);
    }

    public void overrideAdminRateLimit(String adminUserId) {
        try {
            String currentRateLimits = this.matrixHttpClient.getOverriddenRateLimitForUser(adminUserId, this.getMatrixAccessToken());
            JsonValue currentLimits = new JsonGeneratorImpl().createJsonObjectFromString(currentRateLimits);
            JsonValue messagePerSecond = currentLimits.getElement("messages_per_second");
            JsonValue burstCount = currentLimits.getElement("burst_count");
            if (messagePerSecond == null || burstCount == null || messagePerSecond.getIntValue() > 0 || burstCount.getIntValue() > 0) {
                this.matrixHttpClient.overrideRateLimitForUser(adminUserId, 0, 0, this.getMatrixAccessToken());
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error((Object)"Could not update the rate limits for the Matrix admin user", (Throwable)e);
        }
    }

    public MatrixMessage getRoomEvent(String eventId, String roomId, String token) {
        try {
            String accessToken = StringUtils.isNotBlank((CharSequence)token) ? token : this.getMatrixAccessToken();
            MatrixMessage message = this.matrixHttpClient.getEventById(eventId, roomId, accessToken);
            if (message != null && "m.room.message".equals(message.getType())) {
                return message;
            }
        }
        catch (IOException | InterruptedException | JsonException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error("Could not retrieve the Room event {}", new Object[]{eventId, e});
        }
        return null;
    }

    public MatrixMessage getRoomEvent(String eventId, String roomId) {
        try {
            return this.getRoomEvent(eventId, roomId, this.getMatrixAccessToken());
        }
        catch (IOException | JsonException e) {
            LOG.error("Could not retrieve the Room event {}", new Object[]{eventId, e});
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LOG.error("Could not retrieve the Room event {}", new Object[]{eventId, interruptedException});
        }
        return null;
    }

    public Identity findSpaceMemberByMatrixId(String matrixId, Space space) {
        if (this.userMatrixIdsCache.get((Serializable)((Object)(matrixId = this.extractUserId(matrixId)))) != null) {
            return this.identityManager.getOrCreateUserIdentity((String)this.userMatrixIdsCache.get((Serializable)((Object)matrixId)));
        }
        for (String member : space.getMembers()) {
            Identity memberIdentity = this.identityManager.getOrCreateUserIdentity(member);
            if (memberIdentity == null || !memberIdentity.getProfile().getProperties().containsKey("matrixId") || !memberIdentity.getProfile().getProperties().get("matrixId").equals(matrixId)) continue;
            this.userMatrixIdsCache.put((Serializable)((Object)matrixId), (Object)member);
            return memberIdentity;
        }
        return null;
    }

    public String findUserByMatrixId(String userMatrixId) {
        if (StringUtils.isBlank((CharSequence)userMatrixId)) {
            throw new IllegalArgumentException("the user Matrix ID is required");
        }
        String simplifiedMatrixId = this.extractUserId(userMatrixId);
        if (this.userMatrixIdsCache.get((Serializable)((Object)simplifiedMatrixId)) != null) {
            return (String)this.userMatrixIdsCache.get((Serializable)((Object)simplifiedMatrixId));
        }
        try {
            String userAsJson = this.matrixHttpClient.getUser(userMatrixId, this.getMatrixAccessToken());
            Iterator jsonIterator = new JsonGeneratorImpl().createJsonObjectFromString(userAsJson).getElement("threepids").getElements();
            while (jsonIterator.hasNext()) {
                User user;
                JsonValue threePids = (JsonValue)jsonIterator.next();
                if (!"email".equals(threePids.getElement("medium").getStringValue()) || (user = this.getUserByEmail(threePids.getElement("address").getStringValue())) == null) continue;
                this.userMatrixIdsCache.put((Serializable)((Object)userMatrixId), (Object)user.getUserName());
                return user.getUserName();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return userMatrixId;
        }
        catch (Exception e) {
            return userMatrixId;
        }
        return userMatrixId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User getUserByEmail(String email) {
        if (email == null) {
            return null;
        }
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            Query query = new Query();
            query.setEmail(email);
            User[] users = (User[])this.organizationService.getUserHandler().findUsersByQuery(query).load(0, 10);
            if (users.length > 0) {
                User user = users[0];
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception e) {
            User user = null;
            return user;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public String cleanMatrixUsername(String userName) {
        return userName.replaceAll("[^a-zA-Z0-9=_\\-\\.\\/+]+", "-").toLowerCase();
    }

    public String[] getRestrictedGroups() {
        String groupNames = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        if (StringUtils.isBlank((CharSequence)groupNames)) {
            return new String[0];
        }
        return (String[])Arrays.stream(groupNames.split(",")).map(String::trim).toArray(String[]::new);
    }

    public Optional<MediaInfo> getMediaInfo(String mediaId) throws JsonException, IOException, InterruptedException {
        if (mediaId == null || mediaId.isBlank()) {
            return Optional.empty();
        }
        return this.matrixHttpClient.getMediaInfo(mediaId, this.getMatrixAccessToken());
    }

    public void deleteMedia(String mediaId) throws JsonException, IOException, InterruptedException {
        if (mediaId == null || mediaId.isBlank()) {
            throw new IllegalArgumentException("mediaId must not be null or empty");
        }
        this.matrixHttpClient.deleteMedia(mediaId, this.getMatrixAccessToken());
    }

    @Generated
    public boolean isServiceAvailable() {
        return this.serviceAvailable;
    }
}

