/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageError;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.utils.MOPUtils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;

public class PageStorageImpl
implements PageStorage {
    private static final Log LOG = ExoLogger.getLogger(PageStorageImpl.class);
    private static final String NO_NULL_KEY_ACCEPTED = "No null key accepted";
    protected ListenerService listenerService;
    protected LayoutStorage layoutStorage;
    protected SiteDAO siteDAO;
    protected PageDAO pageDAO;

    public PageStorageImpl(ListenerService listenerService, LayoutStorage layoutStorage, SiteDAO siteDAO, PageDAO pageDAO) {
        this.listenerService = listenerService;
        this.layoutStorage = layoutStorage;
        this.siteDAO = siteDAO;
        this.pageDAO = pageDAO;
    }

    public Page getPage(String pageKey) {
        org.exoplatform.portal.mop.page.PageKey key = org.exoplatform.portal.mop.page.PageKey.parse((String)pageKey);
        return this.getPage(key);
    }

    public Page getPage(long id) {
        org.exoplatform.portal.mop.page.PageKey key = this.getPageKey(id);
        return this.getPage(key);
    }

    public Page getPage(org.exoplatform.portal.mop.page.PageKey key) {
        if (key == null) {
            throw new IllegalArgumentException(NO_NULL_KEY_ACCEPTED);
        }
        PageData pageData = this.getPage(key.toPomPageKey());
        if (pageData == null) {
            return null;
        }
        return new Page(pageData);
    }

    public PageContext loadPage(org.exoplatform.portal.mop.page.PageKey key) {
        if (key == null) {
            throw new IllegalArgumentException(NO_NULL_KEY_ACCEPTED);
        }
        PageData pageData = this.getPage(key.toPomPageKey());
        if (pageData == null) {
            return null;
        }
        return new PageContext(key, Utils.toPageState((PageData)pageData));
    }

    public List<PageContext> loadPages(SiteKey siteKey) {
        if (siteKey == null) {
            throw new IllegalArgumentException("No null site key accepted");
        }
        return this.findPages(siteKey.getType(), siteKey.getName(), null, 0, -1);
    }

    public boolean savePage(PageContext page) {
        if (page == null) {
            throw new IllegalArgumentException("PageContext is mandatory");
        }
        PageEntity entity = this.pageDAO.findByKey(page.getKey());
        boolean created = false;
        if (entity == null) {
            entity = new PageEntity();
            this.applyPageContextToEntity(entity, page);
            entity = (PageEntity)this.pageDAO.create(entity);
            created = true;
        } else {
            this.applyPageContextToEntity(entity, page);
            entity = (PageEntity)this.pageDAO.update(entity);
        }
        PageState state = page.getState();
        if (state != null) {
            this.savePagePermissions(PageEntity.class.getName(), entity.getId(), state.getAccessPermissions(), Arrays.asList(state.getEditPermission()));
        }
        if (created) {
            this.broadcastEvent("org.exoplatform.portal.mop.page.page_created", page.getKey());
        } else {
            this.broadcastEvent("org.exoplatform.portal.mop.page.page_updated", page.getKey());
        }
        return created;
    }

    public boolean destroyPage(org.exoplatform.portal.mop.page.PageKey key) {
        if (key == null) {
            throw new IllegalArgumentException("PageKey is mandatory");
        }
        PageEntity page = this.pageDAO.findByKey(key);
        if (page != null) {
            String pageBody = page.getPageBody();
            JSONArray children = MOPUtils.parseJsonArray(pageBody);
            this.layoutStorage.deleteChildren(children);
            this.layoutStorage.deletePermissions(PageEntity.class.getName(), page.getId());
            this.pageDAO.delete(page);
            this.broadcastEvent("org.exoplatform.portal.mop.page.page_destroyed", key);
            return true;
        }
        return false;
    }

    public boolean destroyPages(SiteKey siteKey) {
        List<org.exoplatform.portal.mop.page.PageKey> pageKeys = this.findPageKeys(siteKey.getType(), siteKey.getName(), null, 0, -1);
        pageKeys.forEach(this::destroyPage);
        return !pageKeys.isEmpty();
    }

    public PageContext clone(org.exoplatform.portal.mop.page.PageKey srcPageKey, org.exoplatform.portal.mop.page.PageKey dstPageKey) {
        if (srcPageKey == null) {
            throw new IllegalArgumentException("No null source accepted");
        }
        if (dstPageKey == null) {
            throw new IllegalArgumentException("No null destination accepted");
        }
        PageEntity pageSrc = this.pageDAO.findByKey(srcPageKey);
        if (pageSrc == null) {
            throw new PageServiceException(PageError.CLONE_NO_SRC_PAGE, String.format("Could not clone non existing page %s from site of type %s with id %s", srcPageKey.getName(), srcPageKey.getSite().getType(), srcPageKey.getSite().getName()));
        }
        PageEntity pageDst = this.pageDAO.findByKey(dstPageKey);
        if (pageDst != null) {
            throw new PageServiceException(PageError.CLONE_DST_ALREADY_EXIST, String.format("Could not clone page %s to existing page %s with id %s", dstPageKey.getName(), dstPageKey.getSite().getType(), dstPageKey.getSite().getName()));
        }
        SiteKey siteKey = dstPageKey.getSite();
        SiteEntity owner = this.siteDAO.findByKey(siteKey);
        if (owner == null) {
            throw new PageServiceException(PageError.CLONE_NO_DST_SITE, String.format("Could not clone page %s to non existing site of type %s with id %s", dstPageKey.getName(), siteKey.getTypeName(), siteKey.getName()));
        }
        pageDst = new PageEntity();
        this.applyPageContextToEntity(pageDst, this.buildPageContext(pageSrc));
        List<ComponentEntity> children = this.layoutStorage.clone(PageEntity.class.getName(), pageSrc.getPageBody());
        pageDst.setChildren(children);
        pageDst.setPageBody(((JSONArray)pageDst.toJSON().get((Object)"children")).toJSONString());
        pageDst.setName(dstPageKey.getName());
        pageDst.setOwner(owner);
        pageDst = (PageEntity)this.pageDAO.create(pageDst);
        this.layoutStorage.clonePermissions(PageEntity.class.getName(), pageDst.getId(), pageSrc.getId());
        PageContext pageContext = this.buildPageContext(pageDst);
        this.broadcastEvent("org.exoplatform.portal.mop.page.page_created", dstPageKey);
        return pageContext;
    }

    public QueryResult<PageContext> findPages(int from, int limit, SiteType siteType, String siteName, String pageName, String pageTitle) {
        List<PageContext> pages = this.findPages(siteType, siteName, pageTitle, from, limit);
        return new QueryResult(from, pages.size(), pages);
    }

    public void save(PageData page) {
        SiteKey siteKey = new SiteKey(page.getKey().getType(), page.getKey().getId());
        org.exoplatform.portal.mop.page.PageKey mopKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, page.getKey().getName());
        PageEntity dst = this.pageDAO.findByKey(mopKey);
        if (dst == null) {
            throw new NoSuchDataException("The page " + String.valueOf(page.getKey()) + " not found");
        }
        List children = page.getChildren();
        JSONArray pageBodyJson = MOPUtils.parseJsonArray(dst.getPageBody());
        List<ComponentEntity> newPageBody = this.layoutStorage.saveChildren(pageBodyJson, children);
        dst.setChildren(newPageBody);
        dst.setPageBody(((JSONArray)dst.toJSON().get((Object)"children")).toJSONString());
        this.pageDAO.update(dst);
        this.broadcastEvent("org.exoplatform.portal.mop.page.page_updated", mopKey);
    }

    public PageData getPage(PageKey key) {
        SiteKey siteKey = new SiteKey(key.getType(), key.getId());
        org.exoplatform.portal.mop.page.PageKey pageKey = new org.exoplatform.portal.mop.page.PageKey(siteKey, key.getName());
        PageEntity entity = this.pageDAO.findByKey(pageKey);
        return this.buildPageData(entity);
    }

    protected PageData buildPageData(PageEntity entity) {
        if (entity == null) {
            return null;
        }
        List<String> accessPermissions = this.layoutStorage.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<String> editPermissions = this.layoutStorage.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.EDIT);
        String editPermission = CollectionUtils.isEmpty(editPermissions) ? null : editPermissions.get(0);
        List<ComponentData> children = this.layoutStorage.buildChildren(MOPUtils.parseJsonArray(entity.getPageBody()));
        return new PageData("page_" + entity.getId(), null, entity.getName(), null, null, entity.getFactoryId(), entity.getDisplayName(), entity.getDescription(), null, null, null, entity.getProfiles(), accessPermissions, children, entity.getOwnerType().getName(), entity.getOwnerId(), editPermission, entity.isShowMaxWindow(), entity.isHideSharedLayout(), entity.isShowSharedLayout(), entity.getPageType() != null ? entity.getPageType().name() : null, entity.getLink());
    }

    protected void broadcastEvent(String eventName, org.exoplatform.portal.mop.page.PageKey pageKey) {
        try {
            this.listenerService.broadcast(eventName, (Object)this, (Object)pageKey);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when broadcasting notification " + eventName + " for page " + String.valueOf(pageKey)), (Throwable)e);
        }
    }

    protected org.exoplatform.portal.mop.page.PageKey getPageKey(long id) {
        PageEntity pageEntity = (PageEntity)this.pageDAO.find(Long.valueOf(id));
        return pageEntity == null ? null : new org.exoplatform.portal.mop.page.PageKey(pageEntity.getOwnerType(), pageEntity.getOwnerId(), pageEntity.getName());
    }

    private List<PageContext> findPages(SiteType siteType, String siteName, String pageTitle, int from, int limit) {
        List<org.exoplatform.portal.mop.page.PageKey> pageKeys = this.findPageKeys(siteType, siteName, pageTitle, from, limit);
        return pageKeys.stream().map(this::loadPage).toList();
    }

    private List<org.exoplatform.portal.mop.page.PageKey> findPageKeys(SiteType siteType, String siteName, String pageTitle, int from, int limit) {
        try {
            ListAccess<org.exoplatform.portal.mop.page.PageKey> pagesListAccess = this.pageDAO.findByQuery(siteType, siteName, pageTitle, from, limit);
            org.exoplatform.portal.mop.page.PageKey[] pageKeys = (org.exoplatform.portal.mop.page.PageKey[])pagesListAccess.load(0, pagesListAccess.getSize());
            return Arrays.asList(pageKeys);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Error retrieving pages using query %s, %s, %s", siteType, siteName, pageTitle));
        }
    }

    private void applyPageContextToEntity(PageEntity entity, PageContext pageContext) {
        PageState state = pageContext.getState();
        if (state != null) {
            entity.setDescription(state.getDescription());
            entity.setDisplayName(state.getDisplayName());
            entity.setFactoryId(state.getFactoryId());
            entity.setShowMaxWindow(state.isShowMaxWindow());
            entity.setHideSharedLayout(state.isHideSharedLayout());
            entity.setShowSharedLayout(state.isShowSharedLayout());
            entity.setPageType(!StringUtils.isBlank((CharSequence)state.getType()) ? PageType.valueOf((String)state.getType()) : PageType.PAGE);
            entity.setProfiles(state.getProfiles());
            entity.setLink(state.getLink());
        } else {
            entity.setPageType(PageType.PAGE);
        }
        SiteKey siteKey = pageContext.getKey().getSite();
        entity.setOwner(this.siteDAO.findByKey(siteKey));
        entity.setName(pageContext.getKey().getName());
    }

    private PageContext buildPageContext(PageEntity entity) {
        PageData pageData = this.buildPageData(entity);
        return new PageContext(pageData.getKey().toMopPageKey(), Utils.toPageState((PageData)pageData));
    }

    private void savePagePermissions(String objectType, long objectId, List<String> accessPermissions, List<String> editPermissions) {
        this.layoutStorage.savePermissions(objectType, objectId, PermissionEntity.TYPE.ACCESS, accessPermissions);
        this.layoutStorage.savePermissions(objectType, objectId, PermissionEntity.TYPE.EDIT, editPermissions);
    }
}

