/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.social;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import lombok.Generated;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceJoinRequestReceivedPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.RequestJoinSpacePlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;

    public String getId() {
        return "RequestJoinSpacePlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", this.getFullName(notification.getValueOwnerParameter(SocialNotificationUtils.REQUEST_FROM.getKey()))).replace("{1}", this.getSpaceName(spaceId)));
        PermanentLinkObject object = new PermanentLinkObject("space", spaceId);
        object.addParameter("applicationUri", "members");
        object.addParameter("hash", "pending");
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(object));
        return notificationMessage;
    }

    @Generated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    @Generated
    public SpaceService getSpaceService() {
        return this.spaceService;
    }
}

